/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.export;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.ReadWriteSpan;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.ReadableSpan;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.SpanProcessor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.data.SpanData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SimpleSpanProcessor
implements SpanProcessor {
    private static final e logger = e.a(SimpleSpanProcessor.class.getName());
    private final SpanExporter spanExporter;
    private final boolean sampled;
    private final Set<CompletableResultCode> pendingExports = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    public static SpanProcessor create(SpanExporter spanExporter) {
        Objects.requireNonNull(spanExporter, "exporter");
        return new SimpleSpanProcessor(spanExporter, true);
    }

    SimpleSpanProcessor(SpanExporter spanExporter, boolean bl2) {
        this.spanExporter = Objects.requireNonNull(spanExporter, "spanExporter");
        this.sampled = bl2;
    }

    @Override
    public void onStart(Context context, ReadWriteSpan readWriteSpan) {
    }

    @Override
    public boolean isStartRequired() {
        return false;
    }

    @Override
    public void onEnd(ReadableSpan readableSpan) {
        if (this.sampled && !readableSpan.getSpanContext().isSampled()) {
            return;
        }
        try {
            List<SpanData> list = Collections.singletonList(readableSpan.toSpanData());
            CompletableResultCode completableResultCode = this.spanExporter.export(list);
            this.pendingExports.add(completableResultCode);
            completableResultCode.whenComplete(() -> {
                this.pendingExports.remove(completableResultCode);
                if (!completableResultCode.isSuccess()) {
                    logger.a(e.a.f, "Exporter failed");
                }
            });
        }
        catch (RuntimeException runtimeException) {
            Throwables.throwIfCritical(runtimeException);
            RuntimeException runtimeException2 = runtimeException;
            logger.a(e.a.c, "Exporter threw an Exception", runtimeException2);
        }
    }

    @Override
    public boolean isEndRequired() {
        return true;
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        CompletableResultCode completableResultCode = new CompletableResultCode();
        CompletableResultCode completableResultCode2 = this.forceFlush();
        completableResultCode2.whenComplete(() -> {
            CompletableResultCode completableResultCode3 = this.spanExporter.shutdown();
            completableResultCode3.whenComplete(() -> {
                if (!completableResultCode2.isSuccess() || !completableResultCode3.isSuccess()) {
                    completableResultCode.fail();
                } else {
                    completableResultCode.succeed();
                }
            });
        });
        return completableResultCode;
    }

    @Override
    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofAll(this.pendingExports);
    }

    public String toString() {
        return "SimpleSpanProcessor{spanExporter=" + this.spanExporter + '}';
    }
}

