/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.jregex;

import com.contrastsecurity.thirdparty.jregex.Find;
import com.contrastsecurity.thirdparty.jregex.FindBack;
import com.contrastsecurity.thirdparty.jregex.Term;

public class Optimizer {
    public static final int THRESHOLD = 20;
    private Term atom;
    private int distance;

    static Optimizer find(Term term) {
        return Optimizer.find(term, 0);
    }

    private static Optimizer find(Term term, int n2) {
        if (term == null) {
            return null;
        }
        Term term2 = term.next;
        int n3 = term.type;
        switch (n3) {
            case 0: 
            case 6: 
            case 7: {
                return new Optimizer(term, n2);
            }
            case 1: 
            case 2: {
                if (term.weight <= 20) {
                    return new Optimizer(term, n2);
                }
                return Optimizer.find(term.next, n2 + 1);
            }
            case 4: 
            case 5: {
                return Optimizer.find(term2, n2 + 1);
            }
            case 46: 
            case 47: {
                if (term.minCount > 0) {
                    return Optimizer.find(term.target, n2);
                }
                return null;
            }
        }
        if (n3 >= 11 && n3 <= 31) {
            return Optimizer.find(term2, n2);
        }
        return null;
    }

    private Optimizer(Term term, int n2) {
        this.atom = term;
        this.distance = n2;
    }

    Term makeFirst(Term term) {
        return new Find(this.atom, this.distance, term);
    }

    Term makeBacktrack(Term term) {
        int n2 = term.minCount;
        switch (term.type) {
            case 50: {
                n2 = 0;
            }
            case 51: {
                return new FindBack(this.atom, this.distance, n2, term);
            }
            case 54: {
                return term;
            }
        }
        throw new Error("unexpected iterator's backtracker:" + term);
    }
}

