/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.jregex;

import com.contrastsecurity.agent.k.a;
import com.contrastsecurity.thirdparty.jregex.MatchResult;
import com.contrastsecurity.thirdparty.jregex.Matcher;
import com.contrastsecurity.thirdparty.jregex.PatternSyntaxException;
import com.contrastsecurity.thirdparty.jregex.REFlags;
import com.contrastsecurity.thirdparty.jregex.RETokenizer;
import com.contrastsecurity.thirdparty.jregex.Replacer;
import com.contrastsecurity.thirdparty.jregex.Substitution;
import com.contrastsecurity.thirdparty.jregex.Term;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Hashtable;

public class Pattern
implements REFlags,
Serializable {
    String stringRepr;
    Term root;
    Term root0;
    int memregs;
    int counters;
    int lookaheads;
    Hashtable namedGroupMap;

    protected Pattern() throws PatternSyntaxException {
    }

    public Pattern(String string) throws PatternSyntaxException {
        this(string, 0);
    }

    public Pattern(String string, String string2) throws PatternSyntaxException {
        this.stringRepr = string;
        this.compile(string, Pattern.parseFlags(string2));
    }

    public Pattern(String string, int n2) throws PatternSyntaxException {
        this.compile(string, n2);
    }

    protected void compile(String string, int n2) throws PatternSyntaxException {
        this.stringRepr = string;
        Term.makeTree(string, n2, this);
    }

    public int groupCount() {
        return this.memregs;
    }

    public Integer groupId(String string) {
        return (Integer)this.namedGroupMap.get(string);
    }

    public boolean matches(String string) {
        return this.matcher(string).matches();
    }

    public boolean matches(a a2, String string) {
        return this.matcher(a2, string).matches();
    }

    public boolean startsWith(String string) {
        return this.matcher(string).matchesPrefix();
    }

    public Matcher matcher() {
        return new Matcher(this);
    }

    public Matcher matcher(String string) {
        Matcher matcher = new Matcher(this);
        matcher.setTarget(string);
        return matcher;
    }

    public Matcher matcher(a a2, String string) {
        Matcher matcher = new Matcher(this);
        matcher.setTarget(a2, string);
        return matcher;
    }

    public Matcher matcher(char[] cArray, int n2, int n3) {
        Matcher matcher = new Matcher(this);
        matcher.setTarget(cArray, n2, n3);
        return matcher;
    }

    public Matcher matcher(MatchResult matchResult, int n2) {
        Matcher matcher = new Matcher(this);
        if (matchResult instanceof Matcher) {
            matcher.setTarget((Matcher)matchResult, n2);
        } else {
            matcher.setTarget(matchResult.targetChars(), matchResult.start(n2) + matchResult.targetStart(), matchResult.length(n2));
        }
        return matcher;
    }

    public Matcher matcher(MatchResult matchResult, String string) {
        Integer n2 = matchResult.pattern().groupId(string);
        if (n2 == null) {
            throw new IllegalArgumentException("group not found:" + string);
        }
        int n3 = n2;
        return this.matcher(matchResult, n3);
    }

    public Matcher matcher(Reader reader, int n2) throws IOException {
        Matcher matcher = new Matcher(this);
        matcher.setTarget(reader, n2);
        return matcher;
    }

    public Replacer replacer(String string) {
        return new Replacer(this, string);
    }

    public Replacer replacer(Substitution substitution) {
        return new Replacer(this, substitution);
    }

    public RETokenizer tokenizer(String string) {
        return new RETokenizer(this, string);
    }

    public RETokenizer tokenizer(char[] cArray, int n2, int n3) {
        return new RETokenizer(this, cArray, n2, n3);
    }

    public RETokenizer tokenizer(Reader reader, int n2) throws IOException {
        return new RETokenizer(this, reader, n2);
    }

    public String toString() {
        return this.stringRepr;
    }

    public String toString_d() {
        return this.root.toStringAll();
    }

    static int parseFlags(String string) throws PatternSyntaxException {
        boolean bl2 = true;
        int n2 = string.length();
        int n3 = 0;
        block4: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '+': {
                    bl2 = true;
                    continue block4;
                }
                case '-': {
                    bl2 = false;
                    continue block4;
                }
                default: {
                    int n4 = Pattern.getFlag(c2);
                    if (bl2) {
                        n3 |= n4;
                        continue block4;
                    }
                    n3 &= ~n4;
                }
            }
        }
        return n3;
    }

    static int parseFlags(char[] cArray, int n2, int n3) throws PatternSyntaxException {
        boolean bl2 = true;
        int n4 = 0;
        block4: for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = cArray[n2 + i2];
            switch (c2) {
                case '+': {
                    bl2 = true;
                    continue block4;
                }
                case '-': {
                    bl2 = false;
                    continue block4;
                }
                default: {
                    int n5 = Pattern.getFlag(c2);
                    if (bl2) {
                        n4 |= n5;
                        continue block4;
                    }
                    n4 &= ~n5;
                }
            }
        }
        return n4;
    }

    private static int getFlag(char c2) throws PatternSyntaxException {
        switch (c2) {
            case 'i': {
                return 1;
            }
            case 'm': {
                return 2;
            }
            case 's': {
                return 4;
            }
            case 'x': {
                return 8;
            }
            case 'u': {
                return 16;
            }
            case 'X': {
                return 32;
            }
        }
        throw new PatternSyntaxException("unknown flag: " + c2);
    }
}

