/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.lbmq;

import com.contrastsecurity.thirdparty.lbmq.AbstractOfferable;
import com.contrastsecurity.thirdparty.lbmq.AbstractPollable;
import com.contrastsecurity.thirdparty.lbmq.DefaultSubQueueSelection;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class LinkedBlockingMultiQueue<K, E>
extends AbstractPollable<E> {
    private final ConcurrentHashMap<K, SubQueue> subQueues = new ConcurrentHashMap();
    private final ReentrantLock takeLock = new ReentrantLock();
    private final Condition notEmpty = this.takeLock.newCondition();
    private final AtomicInteger totalCount = new AtomicInteger();
    private final ArrayList<PriorityGroup> priorityGroups = new ArrayList();
    private final SubQueueSelection<K, E> subQueueSelection;

    public LinkedBlockingMultiQueue() {
        this(new DefaultSubQueueSelection());
    }

    public LinkedBlockingMultiQueue(SubQueueSelection<K, E> subQueueSelection) {
        this.subQueueSelection = subQueueSelection;
        this.subQueueSelection.setPriorityGroups(this.priorityGroups);
    }

    public SubQueue addSubQueue(K k2, int n2) {
        return this.addSubQueue(k2, n2, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubQueue addSubQueue(K k2, int n2, int n3) {
        SubQueue subQueue = new SubQueue(k2, n3);
        this.takeLock.lock();
        try {
            SubQueue subQueue2 = this.subQueues.putIfAbsent(k2, subQueue);
            if (subQueue2 == null) {
                int n4 = 0;
                boolean bl2 = false;
                for (PriorityGroup priorityGroup : this.priorityGroups) {
                    if (priorityGroup.priority == n2) {
                        priorityGroup.addQueue(subQueue);
                        bl2 = true;
                        break;
                    }
                    if (priorityGroup.priority > n2) {
                        PriorityGroup priorityGroup2 = new PriorityGroup(n2);
                        this.priorityGroups.add(n4, priorityGroup2);
                        priorityGroup2.addQueue(subQueue);
                        bl2 = true;
                        break;
                    }
                    ++n4;
                }
                if (!bl2) {
                    PriorityGroup priorityGroup = new PriorityGroup(n2);
                    this.priorityGroups.add(priorityGroup);
                    priorityGroup.addQueue(subQueue);
                }
            }
            SubQueue subQueue3 = subQueue2;
            return subQueue3;
        }
        finally {
            this.takeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubQueue removeSubQueue(K k2) {
        this.takeLock.lock();
        try {
            SubQueue subQueue = this.subQueues.remove(k2);
            if (subQueue != null) {
                subQueue.priorityGroup.removeQueue(subQueue);
                if (((SubQueue)subQueue).priorityGroup.queues.size() == 0) {
                    this.priorityGroups.remove(subQueue.priorityGroup);
                }
            }
            SubQueue subQueue2 = subQueue;
            return subQueue2;
        }
        finally {
            this.takeLock.unlock();
        }
    }

    public SubQueue getSubQueue(K k2) {
        return this.subQueues.get(k2);
    }

    private void signalNotEmpty() {
        this.takeLock.lock();
        try {
            this.notEmpty.signal();
        }
        finally {
            this.takeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long l2, TimeUnit timeUnit) throws InterruptedException {
        int n2;
        Object object;
        SubQueue subQueue;
        long l3 = timeUnit.toNanos(l2);
        this.takeLock.lockInterruptibly();
        try {
            while (this.totalCount.get() == 0) {
                if (l3 <= 0L) {
                    E e2 = null;
                    return e2;
                }
                l3 = this.notEmpty.awaitNanos(l3);
            }
            subQueue = this.subQueueSelection.getNext();
            object = subQueue.dequeue();
            n2 = subQueue.count.getAndDecrement();
            if (this.totalCount.getAndDecrement() > 1) {
                this.notEmpty.signal();
            }
        }
        finally {
            this.takeLock.unlock();
        }
        if (n2 == subQueue.capacity) {
            subQueue.signalNotFull();
        }
        return (E)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        int n2;
        Object object;
        SubQueue subQueue;
        this.takeLock.lockInterruptibly();
        try {
            while (this.totalCount.get() == 0) {
                this.notEmpty.await();
            }
            subQueue = this.subQueueSelection.getNext();
            object = subQueue.dequeue();
            n2 = subQueue.count.getAndDecrement();
            if (this.totalCount.getAndDecrement() > 1) {
                this.notEmpty.signal();
            }
        }
        finally {
            this.takeLock.unlock();
        }
        if (n2 == subQueue.capacity) {
            subQueue.signalNotFull();
        }
        return (E)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        int n2;
        Object object;
        SubQueue subQueue;
        this.takeLock.lock();
        try {
            if (this.totalCount.get() == 0) {
                E e2 = null;
                return e2;
            }
            subQueue = this.subQueueSelection.getNext();
            object = subQueue.dequeue();
            n2 = subQueue.count.getAndDecrement();
            if (this.totalCount.getAndDecrement() > 1) {
                this.notEmpty.signal();
            }
        }
        finally {
            this.takeLock.unlock();
        }
        if (n2 == subQueue.capacity) {
            subQueue.signalNotFull();
        }
        return (E)object;
    }

    @Override
    public E peek() {
        this.takeLock.lock();
        try {
            if (this.totalCount.get() == 0) {
                E e2 = null;
                return e2;
            }
            E e3 = this.subQueueSelection.peek();
            return e3;
        }
        finally {
            this.takeLock.unlock();
        }
    }

    public int totalSize() {
        return this.totalCount.get();
    }

    public boolean isEmpty() {
        return this.totalSize() == 0;
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        return this.drainTo(collection, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n2) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        if (n2 <= 0) {
            return 0;
        }
        this.takeLock.lock();
        try {
            int n3;
            int n4 = Math.min(n2, this.totalCount.get());
            int n5 = 0;
            for (n3 = 0; n3 < this.priorityGroups.size() && n5 < n4; n5 += this.priorityGroups.get(n3).drainTo(collection, n4 - n5), ++n3) {
            }
            this.totalCount.getAndAdd(-n5);
            n3 = n5;
            return n3;
        }
        finally {
            this.takeLock.unlock();
        }
    }

    public int getPriorityGroupsCount() {
        return this.priorityGroups.size();
    }

    public static interface SubQueueSelection<K, E> {
        public SubQueue getNext();

        public E peek();

        public void setPriorityGroups(ArrayList<PriorityGroup> var1);
    }

    private static class Node<E> {
        E item;
        Node<E> next = null;

        Node(E e2) {
            this.item = e2;
        }
    }

    public class SubQueue
    extends AbstractOfferable<E> {
        private final K key;
        private final int capacity;
        private PriorityGroup priorityGroup;
        private final ReentrantLock putLock = new ReentrantLock();
        private final Condition notFull = this.putLock.newCondition();
        private final AtomicInteger count = new AtomicInteger();
        private boolean enabled = true;
        private Node<E> head = new Node<Object>(null);
        private Node<E> last = this.head;

        SubQueue(K k2, int n2) {
            if (n2 <= 0) {
                throw new IllegalArgumentException();
            }
            this.key = k2;
            this.capacity = n2;
        }

        @Override
        public int remainingCapacity() {
            return this.capacity - this.count.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            this.fullyLock();
            try {
                Node node = this.head;
                Node node2 = node.next;
                while (node2 != null) {
                    node.next = node;
                    node2.item = null;
                    node = node2;
                    node2 = node.next;
                }
                this.head = this.last;
                int n2 = this.count.getAndSet(0);
                if (n2 == this.capacity) {
                    this.notFull.signal();
                }
                if (this.enabled) {
                    LinkedBlockingMultiQueue.this.totalCount.getAndAdd(-n2);
                }
            }
            finally {
                this.fullyUnlock();
            }
        }

        public void enable(boolean bl2) {
            this.fullyLock();
            try {
                this.enabled = bl2;
                if (bl2) {
                    int n2 = this.count.get();
                    if (n2 > 0) {
                        LinkedBlockingMultiQueue.this.totalCount.getAndAdd(n2);
                        LinkedBlockingMultiQueue.this.notEmpty.signal();
                    }
                } else {
                    LinkedBlockingMultiQueue.this.totalCount.getAndAdd(-this.count.get());
                }
            }
            finally {
                this.fullyUnlock();
            }
        }

        public boolean isEnabled() {
            LinkedBlockingMultiQueue.this.takeLock.lock();
            try {
                boolean bl2 = this.enabled;
                return bl2;
            }
            finally {
                LinkedBlockingMultiQueue.this.takeLock.unlock();
            }
        }

        private void signalNotFull() {
            this.putLock.lock();
            try {
                this.notFull.signal();
            }
            finally {
                this.putLock.unlock();
            }
        }

        private void enqueue(Node<E> node) {
            this.last.next = node;
            this.last = node;
        }

        @Override
        public int size() {
            return this.count.get();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(E e2) throws InterruptedException {
            if (e2 == null) {
                throw new NullPointerException();
            }
            long l2 = -1L;
            Node node = new Node(e2);
            this.putLock.lockInterruptibly();
            try {
                while (this.count.get() == this.capacity) {
                    this.notFull.await();
                }
                this.enqueue(node);
                if (this.count.getAndIncrement() + 1 < this.capacity) {
                    this.notFull.signal();
                }
                if (this.enabled) {
                    l2 = LinkedBlockingMultiQueue.this.totalCount.getAndIncrement();
                }
            }
            finally {
                this.putLock.unlock();
            }
            if (l2 == 0L) {
                LinkedBlockingMultiQueue.this.signalNotEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean offer(E e2, long l2, TimeUnit timeUnit) throws InterruptedException {
            if (e2 == null) {
                throw new NullPointerException();
            }
            long l3 = timeUnit.toNanos(l2);
            long l4 = -1L;
            this.putLock.lockInterruptibly();
            try {
                while (this.count.get() == this.capacity) {
                    if (l3 <= 0L) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    l3 = this.notFull.awaitNanos(l3);
                }
                this.enqueue(new Node(e2));
                if (this.count.getAndIncrement() + 1 < this.capacity) {
                    this.notFull.signal();
                }
                if (this.enabled) {
                    l4 = LinkedBlockingMultiQueue.this.totalCount.getAndIncrement();
                }
            }
            finally {
                this.putLock.unlock();
            }
            if (l4 == 0L) {
                LinkedBlockingMultiQueue.this.signalNotEmpty();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean offer(E e2) {
            if (e2 == null) {
                throw new NullPointerException();
            }
            long l2 = -1L;
            if (this.count.get() == this.capacity) {
                return false;
            }
            this.putLock.lock();
            try {
                if (this.count.get() == this.capacity) {
                    boolean bl2 = false;
                    return bl2;
                }
                this.enqueue(new Node(e2));
                if (this.count.getAndIncrement() + 1 < this.capacity) {
                    this.notFull.signal();
                }
                if (this.enabled) {
                    l2 = LinkedBlockingMultiQueue.this.totalCount.getAndIncrement();
                }
            }
            finally {
                this.putLock.unlock();
            }
            if (l2 == 0L) {
                LinkedBlockingMultiQueue.this.signalNotEmpty();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            if (object == null) {
                return false;
            }
            this.fullyLock();
            try {
                Node node = this.head;
                Node node2 = node.next;
                while (node2 != null) {
                    if (object.equals(node2.item)) {
                        this.unlink(node2, node);
                        boolean bl2 = true;
                        return bl2;
                    }
                    node = node2;
                    node2 = node2.next;
                }
                boolean bl3 = false;
                return bl3;
            }
            finally {
                this.fullyUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object object) {
            if (object == null) {
                return false;
            }
            this.fullyLock();
            try {
                Node node = this.head.next;
                while (node != null) {
                    if (object.equals(node.item)) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    node = node.next;
                }
                boolean bl3 = false;
                return bl3;
            }
            finally {
                this.fullyUnlock();
            }
        }

        void unlink(Node<E> node, Node<E> node2) {
            node.item = null;
            node2.next = node.next;
            if (this.last == node) {
                this.last = node2;
            }
            if (this.count.getAndDecrement() == this.capacity) {
                this.notFull.signal();
            }
            if (this.enabled) {
                LinkedBlockingMultiQueue.this.totalCount.getAndDecrement();
            }
        }

        private void fullyLock() {
            LinkedBlockingMultiQueue.this.takeLock.lock();
            this.putLock.lock();
        }

        private void fullyUnlock() {
            this.putLock.unlock();
            LinkedBlockingMultiQueue.this.takeLock.unlock();
        }

        private E dequeue() {
            Node node = this.head;
            Node node2 = node.next;
            node.next = node;
            this.head = node2;
            Object e2 = node2.item;
            node2.item = null;
            return e2;
        }

        @Override
        public String toString() {
            this.fullyLock();
            try {
                Node node = this.head.next;
                if (node == null) {
                    String string = "[]";
                    return string;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('[');
                while (true) {
                    Object e2;
                    stringBuilder.append((Object)((e2 = node.item) == this ? "(this Collection)" : e2));
                    node = node.next;
                    if (node == null) {
                        String string = stringBuilder.append(']').toString();
                        return string;
                    }
                    stringBuilder.append(',').append(' ');
                }
            }
            finally {
                this.fullyUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            this.fullyLock();
            try {
                int n2 = this.count.get();
                Object[] objectArray = new Object[n2];
                int n3 = 0;
                Object object = this.head.next;
                while (object != null) {
                    objectArray[n3++] = object.item;
                    object = object.next;
                }
                object = objectArray;
                return object;
            }
            finally {
                this.fullyUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] objectArray) {
            this.fullyLock();
            try {
                int n2 = this.count.get();
                if (objectArray.length < n2) {
                    objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2);
                }
                int n3 = 0;
                Object object = this.head.next;
                while (object != null) {
                    objectArray[n3++] = object.item;
                    object = object.next;
                }
                if (objectArray.length > n3) {
                    objectArray[n3] = null;
                }
                object = objectArray;
                return object;
            }
            finally {
                this.fullyUnlock();
            }
        }

        @Override
        public Iterator<E> iterator() {
            return new Itr();
        }

        private class Itr
        implements Iterator<E> {
            private Node<E> current;
            private Node<E> lastRet;
            private E currentElement;

            Itr() {
                SubQueue.this.fullyLock();
                try {
                    this.current = ((SubQueue)SubQueue.this).head.next;
                    if (this.current != null) {
                        this.currentElement = this.current.item;
                    }
                }
                finally {
                    SubQueue.this.fullyUnlock();
                }
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            private Node<E> nextNode(Node<E> node) {
                Node node2;
                while ((node2 = node.next) != node) {
                    if (node2 == null || node2.item != null) {
                        return node2;
                    }
                    node = node2;
                }
                return ((SubQueue)SubQueue.this).head.next;
            }

            @Override
            public E next() {
                SubQueue.this.fullyLock();
                try {
                    if (this.current == null) {
                        throw new NoSuchElementException();
                    }
                    Object e2 = this.currentElement;
                    this.lastRet = this.current;
                    this.current = this.nextNode(this.current);
                    this.currentElement = this.current == null ? null : this.current.item;
                    Object e3 = e2;
                    return e3;
                }
                finally {
                    SubQueue.this.fullyUnlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                if (this.lastRet == null) {
                    throw new IllegalStateException();
                }
                SubQueue.this.fullyLock();
                try {
                    Node node = this.lastRet;
                    this.lastRet = null;
                    Node node2 = SubQueue.this.head;
                    Node node3 = node2.next;
                    while (node3 != null) {
                        if (node3 == node) {
                            SubQueue.this.unlink(node3, node2);
                            break;
                        }
                        node2 = node3;
                        node3 = node3.next;
                    }
                }
                finally {
                    SubQueue.this.fullyUnlock();
                }
            }
        }
    }

    class PriorityGroup {
        final int priority;
        final ArrayList<SubQueue> queues = new ArrayList(0);
        int nextIdx = 0;

        PriorityGroup(int n2) {
            this.priority = n2;
        }

        void addQueue(SubQueue subQueue) {
            this.queues.add(subQueue);
            subQueue.priorityGroup = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeQueue(SubQueue subQueue) {
            Iterator<SubQueue> iterator = this.queues.iterator();
            while (iterator.hasNext()) {
                SubQueue subQueue2 = iterator.next();
                if (subQueue2.key != subQueue.key) continue;
                subQueue.putLock.lock();
                try {
                    iterator.remove();
                    if (this.nextIdx == this.queues.size()) {
                        this.nextIdx = 0;
                    }
                    if (subQueue2.enabled) {
                        LinkedBlockingMultiQueue.this.totalCount.getAndAdd(-subQueue.size());
                    }
                    return;
                }
                finally {
                    subQueue.putLock.unlock();
                }
            }
        }

        SubQueue getNextSubQueue() {
            int n2 = this.nextIdx;
            ArrayList<SubQueue> arrayList = this.queues;
            do {
                SubQueue subQueue = arrayList.get(this.nextIdx);
                ++this.nextIdx;
                if (this.nextIdx == arrayList.size()) {
                    this.nextIdx = 0;
                }
                if (!subQueue.enabled || subQueue.size() <= 0) continue;
                return subQueue;
            } while (this.nextIdx != n2);
            return null;
        }

        int drainTo(Collection<? super E> collection, int n2) {
            int n3 = 0;
            int n4 = 0;
            do {
                SubQueue subQueue = this.queues.get(this.nextIdx);
                ++this.nextIdx;
                if (this.nextIdx == this.queues.size()) {
                    this.nextIdx = 0;
                }
                if (subQueue.enabled && subQueue.size() > 0) {
                    n4 = 0;
                    collection.add(subQueue.dequeue());
                    ++n3;
                    int n5 = subQueue.count.getAndDecrement();
                    if (n5 != subQueue.capacity) continue;
                    subQueue.signalNotFull();
                    continue;
                }
                ++n4;
            } while (n3 < n2 && n4 < this.queues.size());
            return n3;
        }

        E peek() {
            int n2 = this.nextIdx;
            do {
                SubQueue subQueue;
                if ((subQueue = this.queues.get(this.nextIdx)).enabled && subQueue.size() > 0) {
                    return ((SubQueue)subQueue).head.next.item;
                }
                ++this.nextIdx;
                if (this.nextIdx != this.queues.size()) continue;
                this.nextIdx = 0;
            } while (this.nextIdx != n2);
            return null;
        }
    }
}

