/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.codec.net;

import com.contrastsecurity.thirdparty.org.apache.commons.codec.BinaryDecoder;
import com.contrastsecurity.thirdparty.org.apache.commons.codec.BinaryEncoder;
import com.contrastsecurity.thirdparty.org.apache.commons.codec.DecoderException;
import com.contrastsecurity.thirdparty.org.apache.commons.codec.EncoderException;
import com.contrastsecurity.thirdparty.org.apache.commons.codec.net.Utils;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class PercentCodec
implements BinaryDecoder,
BinaryEncoder {
    private static final byte ESCAPE_CHAR = 37;
    private final BitSet alwaysEncodeChars = new BitSet();
    private final boolean plusForSpace;
    private int alwaysEncodeCharsMin = Integer.MAX_VALUE;
    private int alwaysEncodeCharsMax = Integer.MIN_VALUE;

    public PercentCodec() {
        this.plusForSpace = false;
        this.insertAlwaysEncodeChar((byte)37);
    }

    public PercentCodec(byte[] byArray, boolean bl2) {
        this.plusForSpace = bl2;
        this.insertAlwaysEncodeChars(byArray);
    }

    private void insertAlwaysEncodeChars(byte[] byArray) {
        if (byArray != null) {
            for (byte by : byArray) {
                this.insertAlwaysEncodeChar(by);
            }
        }
        this.insertAlwaysEncodeChar((byte)37);
    }

    private void insertAlwaysEncodeChar(byte by) {
        this.alwaysEncodeChars.set(by);
        if (by < this.alwaysEncodeCharsMin) {
            this.alwaysEncodeCharsMin = by;
        }
        if (by > this.alwaysEncodeCharsMax) {
            this.alwaysEncodeCharsMax = by;
        }
    }

    @Override
    public byte[] encode(byte[] byArray) throws EncoderException {
        boolean bl2;
        if (byArray == null) {
            return null;
        }
        int n2 = this.expectedEncodingBytes(byArray);
        boolean bl3 = bl2 = n2 != byArray.length;
        if (bl2 || this.plusForSpace && this.containsSpace(byArray)) {
            return this.doEncode(byArray, n2, bl2);
        }
        return byArray;
    }

    private byte[] doEncode(byte[] byArray, int n2, boolean bl2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        for (byte by : byArray) {
            if (bl2 && this.canEncode(by)) {
                byte by2 = by;
                if (by2 < 0) {
                    by2 = (byte)(256 + by2);
                }
                char c2 = Utils.hexDigit(by2 >> 4);
                char c3 = Utils.hexDigit(by2);
                byteBuffer.put((byte)37);
                byteBuffer.put((byte)c2);
                byteBuffer.put((byte)c3);
                continue;
            }
            if (this.plusForSpace && by == 32) {
                byteBuffer.put((byte)43);
                continue;
            }
            byteBuffer.put(by);
        }
        return byteBuffer.array();
    }

    private int expectedEncodingBytes(byte[] byArray) {
        int n2 = 0;
        for (byte by : byArray) {
            n2 += this.canEncode(by) ? 3 : 1;
        }
        return n2;
    }

    private boolean containsSpace(byte[] byArray) {
        for (byte by : byArray) {
            if (by != 32) continue;
            return true;
        }
        return false;
    }

    private boolean canEncode(byte by) {
        return !this.isAsciiChar(by) || this.inAlwaysEncodeCharsRange(by) && this.alwaysEncodeChars.get(by);
    }

    private boolean inAlwaysEncodeCharsRange(byte by) {
        return by >= this.alwaysEncodeCharsMin && by <= this.alwaysEncodeCharsMax;
    }

    private boolean isAsciiChar(byte by) {
        return by >= 0;
    }

    @Override
    public byte[] decode(byte[] byArray) throws DecoderException {
        if (byArray == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.expectedDecodingBytes(byArray));
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte by = byArray[i2];
            if (by == 37) {
                try {
                    int n2 = Utils.digit16(byArray[++i2]);
                    int n3 = Utils.digit16(byArray[++i2]);
                    byteBuffer.put((byte)((n2 << 4) + n3));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new DecoderException("Invalid percent decoding: ", arrayIndexOutOfBoundsException);
                }
            }
            if (this.plusForSpace && by == 43) {
                byteBuffer.put((byte)32);
                continue;
            }
            byteBuffer.put(by);
        }
        return byteBuffer.array();
    }

    private int expectedDecodingBytes(byte[] byArray) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            byte by;
            n3 += (by = byArray[n3]) == 37 ? 3 : 1;
            ++n2;
        }
        return n2;
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return this.encode((byte[])object);
        }
        throw new EncoderException("Objects of type " + object.getClass().getName() + " cannot be Percent encoded");
    }

    @Override
    public Object decode(Object object) throws DecoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return this.decode((byte[])object);
        }
        throw new DecoderException("Objects of type " + object.getClass().getName() + " cannot be Percent decoded");
    }
}

