/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang3;

import java.util.Objects;
import java.util.Random;

final class CachedRandomBits {
    private final Random random;
    private final byte[] cache;
    private int bitIndex;

    CachedRandomBits(int n2, Random random) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("cacheSize must be positive");
        }
        this.cache = new byte[n2];
        this.random = Objects.requireNonNull(random, "random");
        this.random.nextBytes(this.cache);
        this.bitIndex = 0;
    }

    public int nextBits(int n2) {
        if (n2 > 32 || n2 <= 0) {
            throw new IllegalArgumentException("number of bits must be between 1 and 32");
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (this.bitIndex >> 3 >= this.cache.length) {
                assert (this.bitIndex == this.cache.length * 8);
                this.random.nextBytes(this.cache);
                this.bitIndex = 0;
            }
            int n5 = Math.min(8 - (this.bitIndex & 7), n2 - n4);
            n3 <<= n5;
            n3 |= this.cache[this.bitIndex >> 3] >> (this.bitIndex & 7) & (1 << n5) - 1;
            n4 += n5;
            this.bitIndex += n5;
        }
        return n3;
    }
}

