/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang3;

import com.contrastsecurity.thirdparty.org.apache.commons.lang3.CharSet;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.stream.Streams;

public class CharSetUtils {
    public static boolean containsAny(String string, String ... stringArray) {
        if (StringUtils.isEmpty(string) || CharSetUtils.deepEmpty(stringArray)) {
            return false;
        }
        CharSet charSet = CharSet.getInstance(stringArray);
        for (char c2 : string.toCharArray()) {
            if (!charSet.contains(c2)) continue;
            return true;
        }
        return false;
    }

    public static int count(String string, String ... stringArray) {
        if (StringUtils.isEmpty(string) || CharSetUtils.deepEmpty(stringArray)) {
            return 0;
        }
        CharSet charSet = CharSet.getInstance(stringArray);
        int n2 = 0;
        for (char c2 : string.toCharArray()) {
            if (!charSet.contains(c2)) continue;
            ++n2;
        }
        return n2;
    }

    private static boolean deepEmpty(String[] stringArray) {
        return Streams.of(stringArray).allMatch(StringUtils::isEmpty);
    }

    public static String delete(String string, String ... stringArray) {
        if (StringUtils.isEmpty(string) || CharSetUtils.deepEmpty(stringArray)) {
            return string;
        }
        return CharSetUtils.modify(string, stringArray, false);
    }

    public static String keep(String string, String ... stringArray) {
        if (string == null) {
            return null;
        }
        if (string.isEmpty() || CharSetUtils.deepEmpty(stringArray)) {
            return "";
        }
        return CharSetUtils.modify(string, stringArray, true);
    }

    private static String modify(String string, String[] stringArray, boolean bl2) {
        char[] cArray;
        CharSet charSet = CharSet.getInstance(stringArray);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (char c2 : cArray = string.toCharArray()) {
            if (charSet.contains(c2) != bl2) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String squeeze(String string, String ... stringArray) {
        if (StringUtils.isEmpty(string) || CharSetUtils.deepEmpty(stringArray)) {
            return string;
        }
        CharSet charSet = CharSet.getInstance(stringArray);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        char c2 = cArray[0];
        Character c3 = null;
        Character c4 = null;
        stringBuilder.append(c2);
        for (int i2 = 1; i2 < n2; ++i2) {
            char c5 = cArray[i2];
            if (c5 == c2) {
                if (c3 != null && c5 == c3.charValue()) continue;
                if (c4 == null || c5 != c4.charValue()) {
                    if (charSet.contains(c5)) {
                        c3 = Character.valueOf(c5);
                        continue;
                    }
                    c4 = Character.valueOf(c5);
                }
            }
            stringBuilder.append(c5);
            c2 = c5;
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public CharSetUtils() {
    }
}

