/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang3.builder;

import com.contrastsecurity.thirdparty.org.apache.commons.lang3.ArrayUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.ObjectUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.builder.Diff;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.builder.DiffResult;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.builder.ToStringStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class DiffBuilder<T>
implements com.contrastsecurity.thirdparty.org.apache.commons.lang3.builder.Builder<DiffResult<T>> {
    static final String TO_STRING_FORMAT = "%s differs from %s";
    private final List<Diff<?>> diffs;
    private final boolean equals;
    private final T left;
    private final T right;
    private final ToStringStyle style;
    private final String toStringFormat;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Deprecated
    public DiffBuilder(T t2, T t3, ToStringStyle toStringStyle) {
        this(t2, t3, toStringStyle, true);
    }

    @Deprecated
    public DiffBuilder(T t2, T t3, ToStringStyle toStringStyle, boolean bl2) {
        this(t2, t3, toStringStyle, bl2, TO_STRING_FORMAT);
    }

    private DiffBuilder(T t2, T t3, ToStringStyle toStringStyle, boolean bl2, String string) {
        this.left = Objects.requireNonNull(t2, "left");
        this.right = Objects.requireNonNull(t3, "right");
        this.diffs = new ArrayList();
        this.toStringFormat = string;
        this.style = toStringStyle != null ? toStringStyle : ToStringStyle.DEFAULT_STYLE;
        this.equals = bl2 && Objects.equals(t2, t3);
    }

    private <F> DiffBuilder<T> add(String string, Supplier<F> supplier, Supplier<F> supplier2, Class<F> clazz) {
        this.diffs.add(new SDiff(string, supplier, supplier2, clazz));
        return this;
    }

    public DiffBuilder<T> append(String string, boolean bl2, boolean bl3) {
        return this.equals || bl2 == bl3 ? this : this.add(string, () -> bl2, () -> bl3, Boolean.class);
    }

    public DiffBuilder<T> append(String string, boolean[] blArray, boolean[] blArray2) {
        return this.equals || Arrays.equals(blArray, blArray2) ? this : this.add(string, () -> ArrayUtils.toObject(blArray), () -> ArrayUtils.toObject(blArray2), Boolean[].class);
    }

    public DiffBuilder<T> append(String string, byte by, byte by2) {
        return this.equals || by == by2 ? this : this.add(string, () -> by, () -> by2, Byte.class);
    }

    public DiffBuilder<T> append(String string, byte[] byArray, byte[] byArray2) {
        return this.equals || Arrays.equals(byArray, byArray2) ? this : this.add(string, () -> ArrayUtils.toObject(byArray), () -> ArrayUtils.toObject(byArray2), Byte[].class);
    }

    public DiffBuilder<T> append(String string, char c2, char c3) {
        return this.equals || c2 == c3 ? this : this.add(string, () -> Character.valueOf(c2), () -> Character.valueOf(c3), Character.class);
    }

    public DiffBuilder<T> append(String string, char[] cArray, char[] cArray2) {
        return this.equals || Arrays.equals(cArray, cArray2) ? this : this.add(string, () -> ArrayUtils.toObject(cArray), () -> ArrayUtils.toObject(cArray2), Character[].class);
    }

    public DiffBuilder<T> append(String string, DiffResult<?> diffResult) {
        Objects.requireNonNull(diffResult, "diffResult");
        if (this.equals) {
            return this;
        }
        diffResult.getDiffs().forEach(diff -> this.append(string + "." + diff.getFieldName(), diff.getLeft(), diff.getRight()));
        return this;
    }

    public DiffBuilder<T> append(String string, double d2, double d3) {
        return this.equals || Double.doubleToLongBits(d2) == Double.doubleToLongBits(d3) ? this : this.add(string, () -> d2, () -> d3, Double.class);
    }

    public DiffBuilder<T> append(String string, double[] dArray, double[] dArray2) {
        return this.equals || Arrays.equals(dArray, dArray2) ? this : this.add(string, () -> ArrayUtils.toObject(dArray), () -> ArrayUtils.toObject(dArray2), Double[].class);
    }

    public DiffBuilder<T> append(String string, float f2, float f3) {
        return this.equals || Float.floatToIntBits(f2) == Float.floatToIntBits(f3) ? this : this.add(string, () -> Float.valueOf(f2), () -> Float.valueOf(f3), Float.class);
    }

    public DiffBuilder<T> append(String string, float[] fArray, float[] fArray2) {
        return this.equals || Arrays.equals(fArray, fArray2) ? this : this.add(string, () -> ArrayUtils.toObject(fArray), () -> ArrayUtils.toObject(fArray2), Float[].class);
    }

    public DiffBuilder<T> append(String string, int n2, int n3) {
        return this.equals || n2 == n3 ? this : this.add(string, () -> n2, () -> n3, Integer.class);
    }

    public DiffBuilder<T> append(String string, int[] nArray, int[] nArray2) {
        return this.equals || Arrays.equals(nArray, nArray2) ? this : this.add(string, () -> ArrayUtils.toObject(nArray), () -> ArrayUtils.toObject(nArray2), Integer[].class);
    }

    public DiffBuilder<T> append(String string, long l2, long l3) {
        return this.equals || l2 == l3 ? this : this.add(string, () -> l2, () -> l3, Long.class);
    }

    public DiffBuilder<T> append(String string, long[] lArray, long[] lArray2) {
        return this.equals || Arrays.equals(lArray, lArray2) ? this : this.add(string, () -> ArrayUtils.toObject(lArray), () -> ArrayUtils.toObject(lArray2), Long[].class);
    }

    public DiffBuilder<T> append(String string, Object object, Object object2) {
        Object object3;
        if (this.equals || object == object2) {
            return this;
        }
        Object object4 = object3 = object != null ? object : object2;
        if (ObjectUtils.isArray(object3)) {
            if (object3 instanceof boolean[]) {
                return this.append(string, (boolean[])object, (boolean[])object2);
            }
            if (object3 instanceof byte[]) {
                return this.append(string, (byte[])object, (byte[])object2);
            }
            if (object3 instanceof char[]) {
                return this.append(string, (char[])object, (char[])object2);
            }
            if (object3 instanceof double[]) {
                return this.append(string, (double[])object, (double[])object2);
            }
            if (object3 instanceof float[]) {
                return this.append(string, (float[])object, (float[])object2);
            }
            if (object3 instanceof int[]) {
                return this.append(string, (int[])object, (int[])object2);
            }
            if (object3 instanceof long[]) {
                return this.append(string, (long[])object, (long[])object2);
            }
            if (object3 instanceof short[]) {
                return this.append(string, (short[])object, (short[])object2);
            }
            return this.append(string, (Object[])object, (Object[])object2);
        }
        return Objects.equals(object, object2) ? this : this.add(string, () -> object, () -> object2, Object.class);
    }

    public DiffBuilder<T> append(String string, Object[] objectArray, Object[] objectArray2) {
        return this.equals || Arrays.equals(objectArray, objectArray2) ? this : this.add(string, () -> objectArray, () -> objectArray2, Object[].class);
    }

    public DiffBuilder<T> append(String string, short s2, short s3) {
        return this.equals || s2 == s3 ? this : this.add(string, () -> s2, () -> s3, Short.class);
    }

    public DiffBuilder<T> append(String string, short[] sArray, short[] sArray2) {
        return this.equals || Arrays.equals(sArray, sArray2) ? this : this.add(string, () -> ArrayUtils.toObject(sArray), () -> ArrayUtils.toObject(sArray2), Short[].class);
    }

    @Override
    public DiffResult<T> build() {
        return new DiffResult<T>(this.left, this.right, this.diffs, this.style, this.toStringFormat);
    }

    T getLeft() {
        return this.left;
    }

    T getRight() {
        return this.right;
    }

    public static final class Builder<T> {
        private T left;
        private T right;
        private ToStringStyle style;
        private boolean testObjectsEquals = true;
        private String toStringFormat = "%s differs from %s";

        public DiffBuilder<T> build() {
            return new DiffBuilder(this.left, this.right, this.style, this.testObjectsEquals, this.toStringFormat);
        }

        public Builder<T> setLeft(T t2) {
            this.left = t2;
            return this;
        }

        public Builder<T> setRight(T t2) {
            this.right = t2;
            return this;
        }

        public Builder<T> setStyle(ToStringStyle toStringStyle) {
            this.style = toStringStyle != null ? toStringStyle : ToStringStyle.DEFAULT_STYLE;
            return this;
        }

        public Builder<T> setTestObjectsEquals(boolean bl2) {
            this.testObjectsEquals = bl2;
            return this;
        }

        public Builder<T> setToStringFormat(String string) {
            this.toStringFormat = string != null ? string : DiffBuilder.TO_STRING_FORMAT;
            return this;
        }
    }

    private static final class SDiff<T>
    extends Diff<T> {
        private static final long serialVersionUID = 1L;
        private final transient Supplier<T> leftSupplier;
        private final transient Supplier<T> rightSupplier;

        private SDiff(String string, Supplier<T> supplier, Supplier<T> supplier2, Class<T> clazz) {
            super(string, clazz);
            this.leftSupplier = Objects.requireNonNull(supplier);
            this.rightSupplier = Objects.requireNonNull(supplier2);
        }

        @Override
        public T getLeft() {
            return this.leftSupplier.get();
        }

        @Override
        public T getRight() {
            return this.rightSupplier.get();
        }
    }
}

