/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang3.builder;

import com.contrastsecurity.thirdparty.org.apache.commons.lang3.builder.Diff;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.builder.ToStringBuilder;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.builder.ToStringStyle;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class DiffResult<T>
implements Iterable<Diff<?>> {
    public static final String OBJECTS_SAME_STRING = "";
    private final List<Diff<?>> diffList;
    private final T lhs;
    private final T rhs;
    private final ToStringStyle style;
    private final String toStringFormat;

    DiffResult(T t2, T t3, List<Diff<?>> list, ToStringStyle toStringStyle, String string) {
        this.diffList = Objects.requireNonNull(list, "diffList");
        this.lhs = Objects.requireNonNull(t2, "lhs");
        this.rhs = Objects.requireNonNull(t3, "rhs");
        this.style = Objects.requireNonNull(toStringStyle, "style");
        this.toStringFormat = Objects.requireNonNull(string, "toStringFormat");
    }

    public List<Diff<?>> getDiffs() {
        return Collections.unmodifiableList(this.diffList);
    }

    public T getLeft() {
        return this.lhs;
    }

    public int getNumberOfDiffs() {
        return this.diffList.size();
    }

    public T getRight() {
        return this.rhs;
    }

    public ToStringStyle getToStringStyle() {
        return this.style;
    }

    @Override
    public Iterator<Diff<?>> iterator() {
        return this.diffList.iterator();
    }

    public String toString() {
        return this.toString(this.style);
    }

    public String toString(ToStringStyle toStringStyle) {
        if (this.diffList.isEmpty()) {
            return OBJECTS_SAME_STRING;
        }
        ToStringBuilder toStringBuilder = new ToStringBuilder(this.lhs, toStringStyle);
        ToStringBuilder toStringBuilder2 = new ToStringBuilder(this.rhs, toStringStyle);
        this.diffList.forEach(diff -> {
            toStringBuilder.append(diff.getFieldName(), diff.getLeft());
            toStringBuilder2.append(diff.getFieldName(), diff.getRight());
        });
        return String.format(this.toStringFormat, toStringBuilder.build(), toStringBuilder2.build());
    }
}

