/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang3.exception;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.exception.ExceptionContext;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.exception.ExceptionUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.tuple.ImmutablePair;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.tuple.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultExceptionContext
implements ExceptionContext,
Serializable {
    private static final long serialVersionUID = 20110706L;
    private final List<Pair<String, Object>> contextValues = new ArrayList<Pair<String, Object>>();

    @Override
    public DefaultExceptionContext addContextValue(String string, Object object) {
        this.contextValues.add(new ImmutablePair<String, Object>(string, object));
        return this;
    }

    @Override
    public List<Pair<String, Object>> getContextEntries() {
        return this.contextValues;
    }

    @Override
    public Set<String> getContextLabels() {
        return this.stream().map(Pair::getKey).collect(Collectors.toSet());
    }

    @Override
    public List<Object> getContextValues(String string) {
        return this.stream().filter(pair -> StringUtils.equals(string, (CharSequence)pair.getKey())).map(Pair::getValue).collect(Collectors.toList());
    }

    @Override
    public Object getFirstContextValue(String string) {
        return this.stream().filter(pair -> StringUtils.equals(string, (CharSequence)pair.getKey())).findFirst().map(Pair::getValue).orElse(null);
    }

    @Override
    public String getFormattedExceptionMessage(String string) {
        StringBuilder stringBuilder = new StringBuilder(256);
        if (string != null) {
            stringBuilder.append(string);
        }
        if (!this.contextValues.isEmpty()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append("Exception Context:\n");
            int n2 = 0;
            for (Pair<String, Object> pair : this.contextValues) {
                stringBuilder.append("\t[");
                stringBuilder.append(++n2);
                stringBuilder.append(':');
                stringBuilder.append(pair.getKey());
                stringBuilder.append("=");
                Object object = pair.getValue();
                if (object == null) {
                    stringBuilder.append("null");
                } else {
                    String string2;
                    try {
                        string2 = object.toString();
                    }
                    catch (Exception exception) {
                        Throwables.throwIfCritical(exception);
                        Exception exception2 = exception;
                        string2 = "Exception thrown on toString(): " + ExceptionUtils.getStackTrace(exception2);
                    }
                    stringBuilder.append(string2);
                }
                stringBuilder.append("]\n");
            }
            stringBuilder.append("---------------------------------");
        }
        return stringBuilder.toString();
    }

    @Override
    public DefaultExceptionContext setContextValue(String string, Object object) {
        this.contextValues.removeIf(pair -> StringUtils.equals(string, (CharSequence)pair.getKey()));
        this.addContextValue(string, object);
        return this;
    }

    private Stream<Pair<String, Object>> stream() {
        return this.contextValues.stream();
    }
}

