/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.http.impl.entity;

import com.contrastsecurity.thirdparty.org.apache.http.Header;
import com.contrastsecurity.thirdparty.org.apache.http.HeaderElement;
import com.contrastsecurity.thirdparty.org.apache.http.HttpException;
import com.contrastsecurity.thirdparty.org.apache.http.HttpMessage;
import com.contrastsecurity.thirdparty.org.apache.http.ParseException;
import com.contrastsecurity.thirdparty.org.apache.http.ProtocolException;
import com.contrastsecurity.thirdparty.org.apache.http.annotation.Contract;
import com.contrastsecurity.thirdparty.org.apache.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.org.apache.http.entity.ContentLengthStrategy;
import com.contrastsecurity.thirdparty.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class LaxContentLengthStrategy
implements ContentLengthStrategy {
    public static final LaxContentLengthStrategy INSTANCE = new LaxContentLengthStrategy();
    private final int implicitLen;

    public LaxContentLengthStrategy(int n2) {
        this.implicitLen = n2;
    }

    public LaxContentLengthStrategy() {
        this(-1);
    }

    @Override
    public long determineLength(HttpMessage httpMessage) throws HttpException {
        Args.notNull(httpMessage, "HTTP message");
        Header header = httpMessage.getFirstHeader("Transfer-Encoding");
        if (header != null) {
            HeaderElement[] headerElementArray;
            try {
                headerElementArray = header.getElements();
            }
            catch (ParseException parseException) {
                throw new ProtocolException("Invalid Transfer-Encoding header value: " + header, parseException);
            }
            int n2 = headerElementArray.length;
            if ("identity".equalsIgnoreCase(header.getValue())) {
                return -1L;
            }
            if (n2 > 0 && "chunked".equalsIgnoreCase(headerElementArray[n2 - 1].getName())) {
                return -2L;
            }
            return -1L;
        }
        Header header2 = httpMessage.getFirstHeader("Content-Length");
        if (header2 != null) {
            long l2 = -1L;
            Header[] headerArray = httpMessage.getHeaders("Content-Length");
            for (int i2 = headerArray.length - 1; i2 >= 0; --i2) {
                Header header3 = headerArray[i2];
                try {
                    l2 = Long.parseLong(header3.getValue());
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
            return l2 >= 0L ? l2 : -1L;
        }
        return this.implicitLen;
    }
}

