/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Filter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.ManagerFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.OutputStreamManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.PatternLayout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Booleans;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.CloseShieldOutputStream;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Loader;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PropertiesUtil;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;

@Plugin(name="Console", category="Core", elementType="appender", printObject=true)
public final class ConsoleAppender
extends AbstractOutputStreamAppender<OutputStreamManager> {
    public static final String PLUGIN_NAME = "Console";
    private static final String JANSI_CLASS = "org.fusesource.jansi.WindowsAnsiOutputStream";
    private static ConsoleManagerFactory factory = new ConsoleManagerFactory();
    private static final Target DEFAULT_TARGET = Target.SYSTEM_OUT;
    private static final AtomicInteger COUNT = new AtomicInteger();
    private final Target target;

    private ConsoleAppender(String string, Layout<? extends Serializable> layout, Filter filter, OutputStreamManager outputStreamManager, boolean bl2, Target target, Property[] propertyArray) {
        super(string, layout, filter, bl2, true, propertyArray, outputStreamManager);
        this.target = target;
    }

    @Deprecated
    public static ConsoleAppender createAppender(Layout<? extends Serializable> patternLayout, Filter filter, String string, String string2, String string3, String string4) {
        if (string2 == null) {
            LOGGER.error("No name provided for ConsoleAppender");
            return null;
        }
        if (patternLayout == null) {
            patternLayout = PatternLayout.createDefaultLayout();
        }
        boolean bl2 = Boolean.parseBoolean(string3);
        boolean bl3 = Booleans.parseBoolean(string4, true);
        Target target = string == null ? DEFAULT_TARGET : Target.valueOf(string);
        return new ConsoleAppender(string2, (Layout<? extends Serializable>)patternLayout, filter, ConsoleAppender.getManager(target, bl2, false, patternLayout), bl3, target, null);
    }

    @Deprecated
    public static ConsoleAppender createAppender(Layout<? extends Serializable> patternLayout, Filter filter, Target target, String string, boolean bl2, boolean bl3, boolean bl4) {
        if (string == null) {
            LOGGER.error("No name provided for ConsoleAppender");
            return null;
        }
        if (patternLayout == null) {
            patternLayout = PatternLayout.createDefaultLayout();
        }
        Target target2 = target = target == null ? Target.SYSTEM_OUT : target;
        if (bl2 && bl3) {
            LOGGER.error("Cannot use both follow and direct on ConsoleAppender");
            return null;
        }
        return new ConsoleAppender(string, (Layout<? extends Serializable>)patternLayout, filter, ConsoleAppender.getManager(target, bl2, bl3, patternLayout), bl4, target, null);
    }

    public static ConsoleAppender createDefaultAppenderForLayout(Layout<? extends Serializable> layout) {
        return new ConsoleAppender("DefaultConsole-" + COUNT.incrementAndGet(), layout, null, ConsoleAppender.getDefaultManager(DEFAULT_TARGET, false, false, layout), true, DEFAULT_TARGET, null);
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    private static OutputStreamManager getDefaultManager(Target target, boolean bl2, boolean bl3, Layout<? extends Serializable> layout) {
        OutputStream outputStream = ConsoleAppender.getOutputStream(bl2, bl3, target);
        String string = target.name() + '.' + bl2 + '.' + bl3 + "-" + COUNT.get();
        return OutputStreamManager.getManager(string, new FactoryData(outputStream, string, layout), factory);
    }

    private static OutputStreamManager getManager(Target target, boolean bl2, boolean bl3, Layout<? extends Serializable> layout) {
        OutputStream outputStream = ConsoleAppender.getOutputStream(bl2, bl3, target);
        String string = target.name() + '.' + bl2 + '.' + bl3;
        return OutputStreamManager.getManager(string, new FactoryData(outputStream, string, layout), factory);
    }

    private static OutputStream getOutputStream(boolean bl2, boolean bl3, Target target) {
        OutputStream outputStream;
        String string = Charset.defaultCharset().name();
        try {
            outputStream = target == Target.SYSTEM_OUT ? (bl3 ? new FileOutputStream(FileDescriptor.out) : (bl2 ? new PrintStream((OutputStream)new SystemOutStream(), true, string) : System.out)) : (bl3 ? new FileOutputStream(FileDescriptor.err) : (bl2 ? new PrintStream((OutputStream)new SystemErrStream(), true, string) : System.err));
            outputStream = new CloseShieldOutputStream(outputStream);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Unsupported default encoding " + string, unsupportedEncodingException);
        }
        PropertiesUtil propertiesUtil = PropertiesUtil.getProperties();
        if (!propertiesUtil.isOsWindows() || propertiesUtil.getBooleanProperty("com.contrastsecurity.thirdparty.log4j.skipJansi", true) || bl3) {
            return outputStream;
        }
        try {
            Class<?> clazz = Loader.loadClass(JANSI_CLASS);
            Constructor<?> constructor = clazz.getConstructor(OutputStream.class);
            return new CloseShieldOutputStream((OutputStream)constructor.newInstance(outputStream));
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.debug("Jansi is not installed, cannot find {}", (Object)JANSI_CLASS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.warn("{} is missing the proper constructor", (Object)JANSI_CLASS);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            LOGGER.warn("Unable to instantiate {} due to {}", (Object)JANSI_CLASS, (Object)ConsoleAppender.clean(com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Throwables.getRootCause(exception2).toString()).trim());
        }
        return outputStream;
    }

    private static String clean(String string) {
        return string.replace('\u0000', ' ');
    }

    public Target getTarget() {
        return this.target;
    }

    static /* synthetic */ Target access$200() {
        return DEFAULT_TARGET;
    }

    private static class ConsoleManagerFactory
    implements ManagerFactory<OutputStreamManager, FactoryData> {
        private ConsoleManagerFactory() {
        }

        @Override
        public OutputStreamManager createManager(String string, FactoryData factoryData) {
            return new OutputStreamManager(factoryData.os, factoryData.name, factoryData.layout, true);
        }
    }

    private static class FactoryData {
        private final OutputStream os;
        private final String name;
        private final Layout<? extends Serializable> layout;

        public FactoryData(OutputStream outputStream, String string, Layout<? extends Serializable> layout) {
            this.os = outputStream;
            this.name = string;
            this.layout = layout;
        }
    }

    private static class SystemOutStream
    extends OutputStream {
        @Override
        public void close() {
        }

        @Override
        public void flush() {
            System.out.flush();
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            System.out.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            System.out.write(byArray, n2, n3);
        }

        @Override
        public void write(int n2) throws IOException {
            System.out.write(n2);
        }
    }

    private static class SystemErrStream
    extends OutputStream {
        @Override
        public void close() {
        }

        @Override
        public void flush() {
            System.err.flush();
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            System.err.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            System.err.write(byArray, n2, n3);
        }

        @Override
        public void write(int n2) {
            System.err.write(n2);
        }
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Builder<ConsoleAppender> {
        @PluginBuilderAttribute
        @Required
        private Target target = ConsoleAppender.access$200();
        @PluginBuilderAttribute
        private boolean follow;
        @PluginBuilderAttribute
        private boolean direct;

        public B setTarget(Target target) {
            this.target = target;
            return (B)((Builder)this.asBuilder());
        }

        public B setFollow(boolean bl2) {
            this.follow = bl2;
            return (B)((Builder)this.asBuilder());
        }

        public B setDirect(boolean bl2) {
            this.direct = bl2;
            return (B)((Builder)this.asBuilder());
        }

        @Override
        public ConsoleAppender build() {
            if (!this.isValid()) {
                return null;
            }
            if (this.follow && this.direct) {
                throw new IllegalArgumentException("Cannot use both follow and direct on ConsoleAppender '" + this.getName() + "'");
            }
            Layout<Serializable> layout = this.getOrCreateLayout(this.target.getDefaultCharset());
            return new ConsoleAppender(this.getName(), layout, this.getFilter(), ConsoleAppender.getManager(this.target, this.follow, this.direct, layout), this.isIgnoreExceptions(), this.target, this.getPropertyArray());
        }
    }

    public static enum Target {
        SYSTEM_OUT{

            @Override
            public Charset getDefaultCharset() {
                return this.getCharset("sun.stdout.encoding", Charset.defaultCharset());
            }
        }
        ,
        SYSTEM_ERR{

            @Override
            public Charset getDefaultCharset() {
                return this.getCharset("sun.stderr.encoding", Charset.defaultCharset());
            }
        };


        public abstract Charset getDefaultCharset();

        protected Charset getCharset(String string, Charset charset) {
            return new PropertiesUtil(PropertiesUtil.getSystemProperties()).getCharsetProperty(string, charset);
        }
    }
}

