/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Appender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.ErrorHandler;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AsyncAppender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.LoggerType;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class DefaultErrorHandler
implements ErrorHandler,
Serializable {
    public static final Map<LoggerType, AtomicLong> DROPPED_LOGS;
    private final Appender appender;
    private volatile LoggerType loggerType;

    public DefaultErrorHandler(Appender appender) {
        this.appender = appender instanceof AsyncAppender ? appender : null;
    }

    @Override
    public void error(String string) {
        if (this.loggerType == null && this.appender != null) {
            this.loggerType = LoggerType.from(this.appender);
        }
        if (this.loggerType != null) {
            DROPPED_LOGS.get((Object)this.loggerType).incrementAndGet();
        }
    }

    @Override
    public void error(String string, Throwable throwable) {
    }

    @Override
    public void error(String string, LogEvent logEvent, Throwable throwable) {
    }

    static {
        EnumMap<LoggerType, AtomicLong> enumMap = new EnumMap<LoggerType, AtomicLong>(LoggerType.class);
        for (LoggerType loggerType : LoggerType.values()) {
            enumMap.put(loggerType, new AtomicLong(0L));
        }
        DROPPED_LOGS = Collections.unmodifiableMap(enumMap);
    }
}

