/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Level;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import java.util.Objects;

@Plugin(name="CustomLevel", category="Core", printObject=true)
public final class CustomLevelConfig {
    static final CustomLevelConfig[] EMPTY_ARRAY = new CustomLevelConfig[0];
    private final String levelName;
    private final int intLevel;

    private CustomLevelConfig(String string, int n2) {
        this.levelName = Objects.requireNonNull(string, "levelName is null");
        this.intLevel = n2;
    }

    @PluginFactory
    public static CustomLevelConfig createLevel(@PluginAttribute(value="name") String string, @PluginAttribute(value="intLevel") int n2) {
        StatusLogger.getLogger().debug("Creating CustomLevel(name='{}', intValue={})", (Object)string, (Object)n2);
        Level.forName(string, n2);
        return new CustomLevelConfig(string, n2);
    }

    public String getLevelName() {
        return this.levelName;
    }

    public int getIntLevel() {
        return this.intLevel;
    }

    public int hashCode() {
        return this.intLevel ^ this.levelName.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CustomLevelConfig)) {
            return false;
        }
        CustomLevelConfig customLevelConfig = (CustomLevelConfig)object;
        return this.intLevel == customLevelConfig.intLevel && this.levelName.equals(customLevelConfig.levelName);
    }

    public String toString() {
        return "CustomLevel[name=" + this.levelName + ", intLevel=" + this.intLevel + "]";
    }
}

