/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.xml;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LoggerContext;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.AbstractConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.ConfigurationSource;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Node;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Reconfigurable;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.util.PluginType;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.util.ResolverUtil;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.status.StatusConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Closer;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Integers;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Loader;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Patterns;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlConfiguration
extends AbstractConfiguration
implements Reconfigurable {
    private static final String XINCLUDE_FIXUP_LANGUAGE = "http://apache.org/xml/features/xinclude/fixup-language";
    private static final String XINCLUDE_FIXUP_BASE_URIS = "http://apache.org/xml/features/xinclude/fixup-base-uris";
    private static final String[] VERBOSE_CLASSES = new String[]{ResolverUtil.class.getName()};
    private static final String LOG4J_XSD = "com.contrastsecurity.thirdparty.Log4j-config.xsd";
    private final List<Status> status;
    private Element rootElement;
    private boolean strict;
    private String schemaResource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XmlConfiguration(LoggerContext loggerContext, ConfigurationSource configurationSource) {
        block38: {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            super(loggerContext, configurationSource);
            this.status = new ArrayList<Status>();
            File file = configurationSource.getFile();
            byte[] byArray = null;
            try {
                object6 = configurationSource.getInputStream();
                try {
                    byArray = XmlConfiguration.toByteArray((InputStream)object6);
                }
                finally {
                    Closer.closeSilently((AutoCloseable)object6);
                }
                object5 = new InputSource(new ByteArrayInputStream(byArray));
                ((InputSource)object5).setSystemId(configurationSource.getLocation());
                object4 = XmlConfiguration.newDocumentBuilder(true);
                try {
                    object3 = ((DocumentBuilder)object4).parse((InputSource)object5);
                }
                catch (Exception exception) {
                    Throwables.throwIfCritical(exception);
                    object2 = exception;
                    object = com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Throwables.getRootCause((Throwable)object2);
                    if (!(object instanceof UnsupportedOperationException)) throw object2;
                    LOGGER.warn("The DocumentBuilder {} does not support an operation: {}.Trying again without XInclude...", object4, object2);
                    object3 = XmlConfiguration.newDocumentBuilder(false).parse((InputSource)object5);
                }
                this.rootElement = object3.getDocumentElement();
                object2 = this.processAttributes(this.rootNode, this.rootElement);
                object = new StatusConfiguration().withVerboseClasses(VERBOSE_CLASSES).withStatus(this.getDefaultStatus());
                int n2 = 0;
                for (Map.Entry entry : object2.entrySet()) {
                    String string = (String)entry.getKey();
                    String string2 = this.getConfigurationStrSubstitutor().replace((String)entry.getValue());
                    if ("status".equalsIgnoreCase(string)) {
                        ((StatusConfiguration)object).withStatus(string2);
                        continue;
                    }
                    if ("dest".equalsIgnoreCase(string)) {
                        ((StatusConfiguration)object).withDestination(string2);
                        continue;
                    }
                    if ("shutdownHook".equalsIgnoreCase(string)) {
                        this.isShutdownHookEnabled = !"disable".equalsIgnoreCase(string2);
                        continue;
                    }
                    if ("shutdownTimeout".equalsIgnoreCase(string)) {
                        this.shutdownTimeoutMillis = Long.parseLong(string2);
                        continue;
                    }
                    if ("verbose".equalsIgnoreCase(string)) {
                        ((StatusConfiguration)object).withVerbosity(string2);
                        continue;
                    }
                    if ("packages".equalsIgnoreCase(string)) {
                        this.pluginPackages.addAll(Arrays.asList(string2.split(Patterns.COMMA_SEPARATOR)));
                        continue;
                    }
                    if ("name".equalsIgnoreCase(string)) {
                        this.setName(string2);
                        continue;
                    }
                    if ("strict".equalsIgnoreCase(string)) {
                        this.strict = Boolean.parseBoolean(string2);
                        continue;
                    }
                    if ("schema".equalsIgnoreCase(string)) {
                        this.schemaResource = string2;
                        continue;
                    }
                    if ("monitorInterval".equalsIgnoreCase(string)) {
                        n2 = Integers.parseInt(string2);
                        continue;
                    }
                    if (!"advertiser".equalsIgnoreCase(string)) continue;
                    this.createAdvertiser(string2, configurationSource, byArray, "text/xml");
                }
                this.initializeWatchers(this, configurationSource, n2);
                ((StatusConfiguration)object).initialize();
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                LOGGER.error("Error parsing " + configurationSource.getLocation(), (Throwable)exception);
            }
            if (this.strict && this.schemaResource != null && byArray != null) {
                try {
                    block39: {
                        object6 = Loader.getResourceAsStream(this.schemaResource, XmlConfiguration.class.getClassLoader());
                        object5 = null;
                        try {
                            if (object6 != null) {
                                object4 = new StreamSource((InputStream)object6, LOG4J_XSD);
                                object3 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                                object2 = null;
                                try {
                                    object2 = ((SchemaFactory)object3).newSchema((Source)object4);
                                }
                                catch (SAXException sAXException) {
                                    LOGGER.error("Error parsing Log4j schema", (Throwable)sAXException);
                                }
                                if (object2 != null) {
                                    object = ((Schema)object2).newValidator();
                                    try {
                                        ((Validator)object).validate(new StreamSource(new ByteArrayInputStream(byArray)));
                                    }
                                    catch (IOException iOException) {
                                        LOGGER.error("Error reading configuration for validation", (Throwable)iOException);
                                    }
                                    catch (SAXException sAXException) {
                                        LOGGER.error("Error validating configuration", (Throwable)sAXException);
                                    }
                                }
                            }
                            if (object6 == null) break block38;
                            if (object5 == null) break block39;
                        }
                        catch (Throwable throwable) {
                            try {
                                Throwables.throwIfCritical(throwable);
                                object5 = object4 = throwable;
                                throw object4;
                            }
                            catch (Throwable throwable2) {
                                if (object6 == null) throw throwable2;
                                if (object5 == null) {
                                    ((InputStream)object6).close();
                                    throw throwable2;
                                }
                                try {
                                    ((InputStream)object6).close();
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    Throwables.throwIfCritical(throwable3);
                                    Throwable throwable4 = throwable3;
                                    ((Throwable)object5).addSuppressed(throwable4);
                                    throw throwable2;
                                }
                            }
                        }
                        try {
                            ((InputStream)object6).close();
                        }
                        catch (Throwable throwable) {
                            Throwables.throwIfCritical(throwable);
                            object4 = throwable;
                            ((Throwable)object5).addSuppressed((Throwable)object4);
                        }
                        break block38;
                    }
                    ((InputStream)object6).close();
                }
                catch (Exception exception) {
                    Throwables.throwIfCritical(exception);
                    object6 = exception;
                    LOGGER.error("Unable to access schema {}", (Object)this.schemaResource, object6);
                }
            }
        }
        if (this.getName() != null) return;
        this.setName(configurationSource.getLocation());
    }

    static DocumentBuilder newDocumentBuilder(boolean bl2) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        XmlConfiguration.disableDtdProcessing(documentBuilderFactory);
        if (bl2) {
            XmlConfiguration.enableXInclude(documentBuilderFactory);
        }
        return documentBuilderFactory.newDocumentBuilder();
    }

    private static void disableDtdProcessing(DocumentBuilderFactory documentBuilderFactory) {
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        XmlConfiguration.setFeature(documentBuilderFactory, "http://xml.org/sax/features/external-general-entities", false);
        XmlConfiguration.setFeature(documentBuilderFactory, "http://xml.org/sax/features/external-parameter-entities", false);
        XmlConfiguration.setFeature(documentBuilderFactory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
    }

    private static void setFeature(DocumentBuilderFactory documentBuilderFactory, String string, boolean bl2) {
        try {
            documentBuilderFactory.setFeature(string, bl2);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.warn("The DocumentBuilderFactory [{}] does not support the feature [{}]: {}", (Object)documentBuilderFactory, (Object)string, (Object)parserConfigurationException);
        }
        catch (AbstractMethodError abstractMethodError) {
            LOGGER.warn("The DocumentBuilderFactory [{}] is out of date and does not support setFeature: {}", (Object)documentBuilderFactory, (Object)abstractMethodError);
        }
    }

    private static void enableXInclude(DocumentBuilderFactory documentBuilderFactory) {
        try {
            documentBuilderFactory.setXIncludeAware(true);
            documentBuilderFactory.newDocumentBuilder();
        }
        catch (UnsupportedOperationException | ParserConfigurationException exception) {
            documentBuilderFactory.setXIncludeAware(false);
            LOGGER.warn("The DocumentBuilderFactory [{}] does not support XInclude: {}", (Object)documentBuilderFactory, (Object)exception);
        }
        catch (AbstractMethodError | NoSuchMethodError incompatibleClassChangeError) {
            LOGGER.warn("The DocumentBuilderFactory [{}] is out of date and does not support XInclude: {}", (Object)documentBuilderFactory, (Object)incompatibleClassChangeError);
        }
        XmlConfiguration.setFeature(documentBuilderFactory, XINCLUDE_FIXUP_BASE_URIS, true);
        XmlConfiguration.setFeature(documentBuilderFactory, XINCLUDE_FIXUP_LANGUAGE, true);
    }

    @Override
    public void setup() {
        if (this.rootElement == null) {
            LOGGER.error("No logging configuration");
            return;
        }
        this.constructHierarchy(this.rootNode, this.rootElement);
        if (this.status.size() > 0) {
            for (Status status : this.status) {
                LOGGER.error("Error processing element {} ({}): {}", (Object)status.name, (Object)status.element, (Object)status.errorType);
            }
            return;
        }
        this.rootElement = null;
    }

    @Override
    public Configuration reconfigure() {
        try {
            ConfigurationSource configurationSource = this.getConfigurationSource().resetInputStream();
            if (configurationSource == null) {
                return null;
            }
            XmlConfiguration xmlConfiguration = new XmlConfiguration(this.getLoggerContext(), configurationSource);
            return xmlConfiguration.rootElement == null ? null : xmlConfiguration;
        }
        catch (IOException iOException) {
            LOGGER.error("Cannot locate file {}", (Object)this.getConfigurationSource(), (Object)iOException);
            return null;
        }
    }

    private void constructHierarchy(Node node, Element element) {
        this.processAttributes(node, element);
        StringBuilder stringBuilder = new StringBuilder();
        NodeList nodeList = element.getChildNodes();
        List<Node> list = node.getChildren();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            org.w3c.dom.Node node2;
            org.w3c.dom.Node node3 = nodeList.item(i2);
            if (node3 instanceof Element) {
                node2 = (Element)node3;
                String string = this.getType((Element)node2);
                PluginType<?> pluginType = this.pluginManager.getPluginType(string);
                Node node4 = new Node(node, string, pluginType);
                this.constructHierarchy(node4, (Element)node2);
                if (pluginType == null) {
                    String string2 = node4.getValue();
                    if (!node4.hasChildren() && string2 != null) {
                        node.getAttributes().put(string, string2);
                        continue;
                    }
                    this.status.add(new Status(string, element, ErrorType.CLASS_NOT_FOUND));
                    continue;
                }
                list.add(node4);
                continue;
            }
            if (!(node3 instanceof Text)) continue;
            node2 = (Text)node3;
            stringBuilder.append(node2.getData());
        }
        String string = stringBuilder.toString().trim();
        if (string.length() > 0 || !node.hasChildren() && !node.isRoot()) {
            node.setValue(string);
        }
    }

    private String getType(Element element) {
        if (this.strict) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                Attr attr;
                org.w3c.dom.Node node = namedNodeMap.item(i2);
                if (!(node instanceof Attr) || !(attr = (Attr)node).getName().equalsIgnoreCase("type")) continue;
                String string = attr.getValue();
                namedNodeMap.removeNamedItem(attr.getName());
                return string;
            }
        }
        return element.getTagName();
    }

    private Map<String, String> processAttributes(Node node, Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        Map<String, String> map = node.getAttributes();
        for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
            Attr attr;
            org.w3c.dom.Node node2 = namedNodeMap.item(i2);
            if (!(node2 instanceof Attr) || (attr = (Attr)node2).getName().equals("xml:base")) continue;
            map.put(attr.getName(), attr.getValue());
        }
        return map;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[location=" + this.getConfigurationSource() + "]";
    }

    private static class Status {
        private final Element element;
        private final String name;
        private final ErrorType errorType;

        public Status(String string, Element element, ErrorType errorType) {
            this.name = string;
            this.element = element;
            this.errorType = errorType;
        }

        public String toString() {
            return "Status [name=" + this.name + ", element=" + this.element + ", errorType=" + (Object)((Object)this.errorType) + "]";
        }
    }

    private static enum ErrorType {
        CLASS_NOT_FOUND;

    }
}

