/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.ArrayPatternConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.OptionConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PerformanceSensitive;

@PerformanceSensitive(value={"allocation"})
public final class LiteralPatternConverter
extends LogEventPatternConverter
implements ArrayPatternConverter {
    private final String literal;
    private final Configuration config;
    private final boolean substitute;

    public LiteralPatternConverter(Configuration configuration, String string, boolean bl2) {
        super("Literal", "literal");
        this.literal = bl2 ? OptionConverter.convertSpecialChars(string) : string;
        this.config = configuration;
        this.substitute = configuration != null && LiteralPatternConverter.containsSubstitutionSequence(string);
    }

    static boolean containsSubstitutionSequence(String string) {
        return string != null && string.contains("${");
    }

    @Override
    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        stringBuilder.append(this.substitute ? this.config.getStrSubstitutor().replace(logEvent, this.literal) : this.literal);
    }

    @Override
    public void format(Object object, StringBuilder stringBuilder) {
        stringBuilder.append(this.substitute ? this.config.getStrSubstitutor().replace(this.literal) : this.literal);
    }

    @Override
    public void format(StringBuilder stringBuilder, Object ... objectArray) {
        stringBuilder.append(this.substitute ? this.config.getStrSubstitutor().replace(this.literal) : this.literal);
    }

    public String getLiteral() {
        return this.literal;
    }

    @Override
    public boolean isVariable() {
        return false;
    }

    public String toString() {
        return "LiteralPatternConverter[literal=" + this.literal + ", config=" + this.config + ", substitute=" + this.substitute + "]";
    }
}

