/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.script;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.script.AbstractScript;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.ExtensionLanguageMapping;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.FileUtils;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.IOUtils;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.NetUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;

@Plugin(name="ScriptFile", category="Core", printObject=true)
public class ScriptFile
extends AbstractScript {
    private final Path filePath;
    private final boolean isWatched;

    public ScriptFile(String string, Path path, String string2, boolean bl2, String string3) {
        super(string, string2, string3);
        this.filePath = path;
        this.isWatched = bl2;
    }

    public Path getPath() {
        return this.filePath;
    }

    public boolean isWatched() {
        return this.isWatched;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PluginFactory
    public static ScriptFile createScript(@PluginAttribute(value="name") String string, @PluginAttribute(value="language") String string2, @PluginAttribute(value="path") String string3, @PluginAttribute(value="isWatched") Boolean bl2, @PluginAttribute(value="charset") Charset charset) {
        Boolean bl3;
        Object object;
        Object object2;
        File file;
        URI uRI;
        block17: {
            Object object3;
            if (string3 == null) {
                LOGGER.error("No script path provided for ScriptFile");
                return null;
            }
            if (string == null) {
                string = string3;
            }
            uRI = NetUtils.toURI(string3);
            file = FileUtils.fileFromUri(uRI);
            if (string2 == null && file != null && (object3 = FileUtils.getFileExtension(file)) != null && (object2 = ExtensionLanguageMapping.getByExtension((String)object3)) != null) {
                string2 = object2.getLanguage();
            }
            if (string2 == null) {
                LOGGER.info("No script language supplied, defaulting to {}", (Object)"JavaScript");
                string2 = "JavaScript";
            }
            object3 = charset == null ? Charset.defaultCharset() : charset;
            try {
                block18: {
                    object = new InputStreamReader(file != null ? new FileInputStream(file) : uRI.toURL().openStream(), (Charset)object3);
                    Throwable throwable = null;
                    try {
                        object2 = IOUtils.toString((Reader)object);
                        if (object == null) break block17;
                        if (throwable == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        try {
                            Throwable throwable5;
                            Throwables.throwIfCritical(throwable2);
                            throwable = throwable5 = throwable2;
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (object == null) throw throwable6;
                            if (throwable == null) {
                                ((Reader)object).close();
                                throw throwable6;
                            }
                            try {
                                ((Reader)object).close();
                                throw throwable6;
                            }
                            catch (Throwable throwable3) {
                                Throwables.throwIfCritical(throwable3);
                                Throwable throwable8 = throwable3;
                                throwable.addSuppressed(throwable8);
                                throw throwable6;
                            }
                        }
                    }
                    try {
                        ((Reader)object).close();
                    }
                    catch (Throwable throwable4) {
                        Throwables.throwIfCritical(throwable4);
                        Throwable throwable3 = throwable4;
                        throwable.addSuppressed(throwable3);
                    }
                    break block17;
                }
                ((Reader)object).close();
            }
            catch (IOException iOException) {
                LOGGER.error("{}: language={}, path={}, actualCharset={}", (Object)iOException.getClass().getSimpleName(), (Object)string2, (Object)string3, object3);
                return null;
            }
        }
        Object object3 = object = file != null ? Paths.get(file.toURI()) : Paths.get(uRI);
        if (object == null) {
            LOGGER.error("Unable to convert {} to a Path", (Object)uRI.toString());
            return null;
        }
        if (bl2 == null) {
            bl3 = Boolean.FALSE;
            return new ScriptFile(string, (Path)object, string2, bl3, (String)object2);
        }
        bl3 = bl2;
        return new ScriptFile(string, (Path)object, string2, bl3, (String)object2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.getName().equals(this.filePath.toString())) {
            stringBuilder.append("name=").append(this.getName()).append(", ");
        }
        stringBuilder.append("path=").append(this.filePath);
        if (this.getLanguage() != null) {
            stringBuilder.append(", language=").append(this.getLanguage());
        }
        stringBuilder.append(", isWatched=").append(this.isWatched);
        return stringBuilder.toString();
    }
}

