/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.msgpack.value;

import com.contrastsecurity.thirdparty.org.msgpack.value.ImmutableArrayValue;
import com.contrastsecurity.thirdparty.org.msgpack.value.ImmutableBinaryValue;
import com.contrastsecurity.thirdparty.org.msgpack.value.ImmutableBooleanValue;
import com.contrastsecurity.thirdparty.org.msgpack.value.ImmutableExtensionValue;
import com.contrastsecurity.thirdparty.org.msgpack.value.ImmutableFloatValue;
import com.contrastsecurity.thirdparty.org.msgpack.value.ImmutableIntegerValue;
import com.contrastsecurity.thirdparty.org.msgpack.value.ImmutableMapValue;
import com.contrastsecurity.thirdparty.org.msgpack.value.ImmutableNilValue;
import com.contrastsecurity.thirdparty.org.msgpack.value.ImmutableStringValue;
import com.contrastsecurity.thirdparty.org.msgpack.value.ImmutableTimestampValue;
import com.contrastsecurity.thirdparty.org.msgpack.value.MapValue;
import com.contrastsecurity.thirdparty.org.msgpack.value.Value;
import com.contrastsecurity.thirdparty.org.msgpack.value.impl.ImmutableArrayValueImpl;
import com.contrastsecurity.thirdparty.org.msgpack.value.impl.ImmutableBigIntegerValueImpl;
import com.contrastsecurity.thirdparty.org.msgpack.value.impl.ImmutableBinaryValueImpl;
import com.contrastsecurity.thirdparty.org.msgpack.value.impl.ImmutableBooleanValueImpl;
import com.contrastsecurity.thirdparty.org.msgpack.value.impl.ImmutableDoubleValueImpl;
import com.contrastsecurity.thirdparty.org.msgpack.value.impl.ImmutableExtensionValueImpl;
import com.contrastsecurity.thirdparty.org.msgpack.value.impl.ImmutableLongValueImpl;
import com.contrastsecurity.thirdparty.org.msgpack.value.impl.ImmutableMapValueImpl;
import com.contrastsecurity.thirdparty.org.msgpack.value.impl.ImmutableNilValueImpl;
import com.contrastsecurity.thirdparty.org.msgpack.value.impl.ImmutableStringValueImpl;
import com.contrastsecurity.thirdparty.org.msgpack.value.impl.ImmutableTimestampValueImpl;
import java.math.BigInteger;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ValueFactory {
    private ValueFactory() {
    }

    public static ImmutableNilValue newNil() {
        return ImmutableNilValueImpl.get();
    }

    public static ImmutableBooleanValue newBoolean(boolean bl2) {
        return bl2 ? ImmutableBooleanValueImpl.TRUE : ImmutableBooleanValueImpl.FALSE;
    }

    public static ImmutableIntegerValue newInteger(byte by) {
        return new ImmutableLongValueImpl(by);
    }

    public static ImmutableIntegerValue newInteger(short s2) {
        return new ImmutableLongValueImpl(s2);
    }

    public static ImmutableIntegerValue newInteger(int n2) {
        return new ImmutableLongValueImpl(n2);
    }

    public static ImmutableIntegerValue newInteger(long l2) {
        return new ImmutableLongValueImpl(l2);
    }

    public static ImmutableIntegerValue newInteger(BigInteger bigInteger) {
        return new ImmutableBigIntegerValueImpl(bigInteger);
    }

    public static ImmutableFloatValue newFloat(float f2) {
        return new ImmutableDoubleValueImpl(f2);
    }

    public static ImmutableFloatValue newFloat(double d2) {
        return new ImmutableDoubleValueImpl(d2);
    }

    public static ImmutableBinaryValue newBinary(byte[] byArray) {
        return ValueFactory.newBinary(byArray, false);
    }

    public static ImmutableBinaryValue newBinary(byte[] byArray, boolean bl2) {
        if (bl2) {
            return new ImmutableBinaryValueImpl(byArray);
        }
        return new ImmutableBinaryValueImpl(Arrays.copyOf(byArray, byArray.length));
    }

    public static ImmutableBinaryValue newBinary(byte[] byArray, int n2, int n3) {
        return ValueFactory.newBinary(byArray, n2, n3, false);
    }

    public static ImmutableBinaryValue newBinary(byte[] byArray, int n2, int n3, boolean bl2) {
        if (bl2 && n2 == 0 && n3 == byArray.length) {
            return new ImmutableBinaryValueImpl(byArray);
        }
        return new ImmutableBinaryValueImpl(Arrays.copyOfRange(byArray, n2, n3));
    }

    public static ImmutableStringValue newString(String string) {
        return new ImmutableStringValueImpl(string);
    }

    public static ImmutableStringValue newString(byte[] byArray) {
        return new ImmutableStringValueImpl(byArray);
    }

    public static ImmutableStringValue newString(byte[] byArray, boolean bl2) {
        if (bl2) {
            return new ImmutableStringValueImpl(byArray);
        }
        return new ImmutableStringValueImpl(Arrays.copyOf(byArray, byArray.length));
    }

    public static ImmutableStringValue newString(byte[] byArray, int n2, int n3) {
        return ValueFactory.newString(byArray, n2, n3, false);
    }

    public static ImmutableStringValue newString(byte[] byArray, int n2, int n3, boolean bl2) {
        if (bl2 && n2 == 0 && n3 == byArray.length) {
            return new ImmutableStringValueImpl(byArray);
        }
        return new ImmutableStringValueImpl(Arrays.copyOfRange(byArray, n2, n3));
    }

    public static ImmutableArrayValue newArray(List<? extends Value> list) {
        if (list.isEmpty()) {
            return ImmutableArrayValueImpl.empty();
        }
        Value[] valueArray = list.toArray(new Value[list.size()]);
        return new ImmutableArrayValueImpl(valueArray);
    }

    public static ImmutableArrayValue newArray(Value ... valueArray) {
        if (valueArray.length == 0) {
            return ImmutableArrayValueImpl.empty();
        }
        return new ImmutableArrayValueImpl(Arrays.copyOf(valueArray, valueArray.length));
    }

    public static ImmutableArrayValue newArray(Value[] valueArray, boolean bl2) {
        if (valueArray.length == 0) {
            return ImmutableArrayValueImpl.empty();
        }
        if (bl2) {
            return new ImmutableArrayValueImpl(valueArray);
        }
        return new ImmutableArrayValueImpl(Arrays.copyOf(valueArray, valueArray.length));
    }

    public static ImmutableArrayValue emptyArray() {
        return ImmutableArrayValueImpl.empty();
    }

    public static <K extends Value, V extends Value> ImmutableMapValue newMap(Map<K, V> map) {
        Value[] valueArray = new Value[map.size() * 2];
        int n2 = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            valueArray[n2] = (Value)entry.getKey();
            valueArray[++n2] = (Value)entry.getValue();
            ++n2;
        }
        return new ImmutableMapValueImpl(valueArray);
    }

    public static ImmutableMapValue newMap(Value ... valueArray) {
        if (valueArray.length == 0) {
            return ImmutableMapValueImpl.empty();
        }
        return new ImmutableMapValueImpl(Arrays.copyOf(valueArray, valueArray.length));
    }

    public static ImmutableMapValue newMap(Value[] valueArray, boolean bl2) {
        if (valueArray.length == 0) {
            return ImmutableMapValueImpl.empty();
        }
        if (bl2) {
            return new ImmutableMapValueImpl(valueArray);
        }
        return new ImmutableMapValueImpl(Arrays.copyOf(valueArray, valueArray.length));
    }

    public static ImmutableMapValue emptyMap() {
        return ImmutableMapValueImpl.empty();
    }

    @SafeVarargs
    public static MapValue newMap(Map.Entry<? extends Value, ? extends Value> ... entryArray) {
        Value[] valueArray = new Value[entryArray.length * 2];
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            valueArray[i2 * 2] = entryArray[i2].getKey();
            valueArray[i2 * 2 + 1] = entryArray[i2].getValue();
        }
        return ValueFactory.newMap(valueArray, true);
    }

    public static MapBuilder newMapBuilder() {
        return new MapBuilder();
    }

    public static Map.Entry<Value, Value> newMapEntry(Value value, Value value2) {
        return new AbstractMap.SimpleEntry<Value, Value>(value, value2);
    }

    public static ImmutableExtensionValue newExtension(byte by, byte[] byArray) {
        return new ImmutableExtensionValueImpl(by, byArray);
    }

    public static ImmutableTimestampValue newTimestamp(Instant instant) {
        return new ImmutableTimestampValueImpl(instant);
    }

    public static ImmutableTimestampValue newTimestamp(long l2) {
        return ValueFactory.newTimestamp(Instant.ofEpochMilli(l2));
    }

    public static ImmutableTimestampValue newTimestamp(long l2, int n2) {
        return ValueFactory.newTimestamp(Instant.ofEpochSecond(l2, n2));
    }

    public static class MapBuilder {
        private final Map<Value, Value> map = new LinkedHashMap<Value, Value>();

        public MapValue build() {
            return ValueFactory.newMap(this.map);
        }

        public MapBuilder put(Map.Entry<? extends Value, ? extends Value> entry) {
            this.put(entry.getKey(), entry.getValue());
            return this;
        }

        public MapBuilder put(Value value, Value value2) {
            this.map.put(value, value2);
            return this;
        }

        public MapBuilder putAll(Iterable<? extends Map.Entry<? extends Value, ? extends Value>> iterable) {
            for (Map.Entry<? extends Value, ? extends Value> entry : iterable) {
                this.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public MapBuilder putAll(Map<? extends Value, ? extends Value> map) {
            for (Map.Entry<? extends Value, ? extends Value> entry : map.entrySet()) {
                this.put(entry);
            }
            return this;
        }
    }
}

