/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.ast;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.org.mvel2.CompileException;
import com.contrastsecurity.thirdparty.org.mvel2.DataConversion;
import com.contrastsecurity.thirdparty.org.mvel2.ErrorDetail;
import com.contrastsecurity.thirdparty.org.mvel2.MVEL;
import com.contrastsecurity.thirdparty.org.mvel2.ParserContext;
import com.contrastsecurity.thirdparty.org.mvel2.PropertyAccessor;
import com.contrastsecurity.thirdparty.org.mvel2.ast.ASTNode;
import com.contrastsecurity.thirdparty.org.mvel2.ast.ArraySize;
import com.contrastsecurity.thirdparty.org.mvel2.ast.Function;
import com.contrastsecurity.thirdparty.org.mvel2.ast.TypeDescriptor;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.Accessor;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.ExecutableStatement;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.PropertyVerifier;
import com.contrastsecurity.thirdparty.org.mvel2.integration.VariableResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.optimizers.OptimizerFactory;
import com.contrastsecurity.thirdparty.org.mvel2.util.ArrayTools;
import com.contrastsecurity.thirdparty.org.mvel2.util.CompilerTools;
import com.contrastsecurity.thirdparty.org.mvel2.util.ErrorUtil;
import com.contrastsecurity.thirdparty.org.mvel2.util.ParseTools;
import com.contrastsecurity.thirdparty.org.mvel2.util.ReflectionUtil;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;

public class NewObjectNode
extends ASTNode {
    private transient Accessor newObjectOptimizer;
    private TypeDescriptor typeDescr;
    private char[] name;
    private static final Class[] EMPTYCLS = new Class[0];

    public NewObjectNode(TypeDescriptor typeDescriptor, int n2, ParserContext parserContext) {
        super(parserContext);
        this.typeDescr = typeDescriptor;
        this.fields = n2;
        this.expr = typeDescriptor.getExpr();
        this.start = typeDescriptor.getStart();
        this.offset = typeDescriptor.getOffset();
        this.name = this.offset < this.expr.length ? ParseTools.subArray(this.expr, this.start, this.start + this.offset) : this.expr;
        if ((n2 & 0x10) != 0) {
            String[] stringArray;
            if (parserContext != null && parserContext.hasImport(typeDescriptor.getClassName())) {
                parserContext.setAllowBootstrapBypass(false);
                this.egressType = parserContext.getImport(typeDescriptor.getClassName());
            } else {
                try {
                    this.egressType = Class.forName(typeDescriptor.getClassName(), true, this.getClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (parserContext.isStrongTyping()) {
                        parserContext.addError(new ErrorDetail(this.expr, this.start, true, "could not resolve class: " + typeDescriptor.getClassName()));
                    }
                    return;
                }
            }
            if (this.egressType != null) {
                this.rewriteClassReferenceToFQCN(n2);
                if (typeDescriptor.isArray()) {
                    try {
                        this.egressType = this.egressType.isPrimitive() ? ReflectionUtil.toPrimitiveArrayType(this.egressType) : ParseTools.findClass(null, ParseTools.repeatChar('[', typeDescriptor.getArrayLength()) + "L" + this.egressType.getName() + ";", parserContext);
                    }
                    catch (Exception stringArray2) {
                        Throwables.throwIfCritical((Throwable)stringArray2);
                        stringArray = stringArray2;
                        stringArray.printStackTrace();
                    }
                }
            }
            if (parserContext != null) {
                if (this.egressType == null) {
                    parserContext.addError(new ErrorDetail(this.expr, this.start, true, "could not resolve class: " + typeDescriptor.getClassName()));
                    return;
                }
                if (!typeDescriptor.isArray()) {
                    stringArray = ParseTools.captureContructorAndResidual(this.expr, this.start, this.offset);
                    List<char[]> list = ParseTools.parseMethodOrConstructor(stringArray[0].toCharArray());
                    Object[] objectArray = new Class[list.size()];
                    for (int i2 = 0; i2 < objectArray.length; ++i2) {
                        objectArray[i2] = MVEL.analyze(list.get(i2), parserContext);
                    }
                    if (ParseTools.getBestConstructorCandidate((Class[])objectArray, this.egressType, true) == null && parserContext.isStrongTyping()) {
                        parserContext.addError(new ErrorDetail(this.expr, this.start, parserContext.isStrongTyping(), "could not resolve constructor " + typeDescriptor.getClassName() + Arrays.toString(objectArray)));
                    }
                    if (stringArray.length == 2) {
                        String string = stringArray[1].trim();
                        if (string.length() == 0) {
                            return;
                        }
                        this.egressType = new PropertyVerifier(string, parserContext, this.egressType).analyze();
                    }
                }
            }
        }
    }

    private void rewriteClassReferenceToFQCN(int n2) {
        String string = this.egressType.getName();
        if (this.typeDescr.getClassName().indexOf(46) == -1) {
            int n3 = ArrayTools.findFirst('(', 0, this.name.length, this.name);
            char[] cArray = string.toCharArray();
            if (n3 == -1) {
                n3 = cArray.length;
                this.name = new char[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    this.name[i2] = cArray[i2];
                }
            } else {
                int n4;
                char[] cArray2 = new char[cArray.length + (this.name.length - n3)];
                for (n4 = 0; n4 < cArray.length; ++n4) {
                    cArray2[n4] = cArray[n4];
                }
                n4 = this.name.length - n3;
                int n5 = cArray.length;
                for (int i3 = 0; i3 < n4; ++i3) {
                    cArray2[i3 + n5] = this.name[i3 + n3];
                }
                this.name = cArray2;
            }
            this.typeDescr.updateClassName(this.name, 0, this.name.length, n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getReducedValueAccelerated(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        Throwable throwable22;
        block15: {
            Object v2;
            block14: {
                Object v1;
                Object object3;
                block13: {
                    Object object4;
                    if (this.newObjectOptimizer != null) return this.newObjectOptimizer.getValue(object, object2, variableResolverFactory);
                    if (this.egressType == null && variableResolverFactory != null && variableResolverFactory.isResolveable(this.typeDescr.getClassName())) {
                        try {
                            this.egressType = (Class)variableResolverFactory.getVariableResolver(this.typeDescr.getClassName()).getValue();
                            this.rewriteClassReferenceToFQCN(16);
                            if (this.typeDescr.isArray()) {
                                try {
                                    this.egressType = ParseTools.findClass(variableResolverFactory, ParseTools.repeatChar('[', this.typeDescr.getArrayLength()) + "L" + this.egressType.getName() + ";", this.pCtx);
                                }
                                catch (Exception exception) {
                                    Throwables.throwIfCritical(exception);
                                    object4 = exception;
                                }
                            }
                        }
                        catch (ClassCastException classCastException) {
                            throw new CompileException("cannot construct object: " + this.typeDescr.getClassName() + " is not a class reference", this.expr, this.start, classCastException);
                        }
                    }
                    if (this.typeDescr.isArray()) {
                        this.newObjectOptimizer = new NewObjectArray(ParseTools.getBaseComponentType(this.egressType.getComponentType()), this.typeDescr.getCompiledArraySize());
                        return this.newObjectOptimizer.getValue(object, object2, variableResolverFactory);
                    }
                    try {
                        block12: {
                            try {
                                object4 = OptimizerFactory.getThreadAccessorOptimizer();
                                ParserContext parserContext = this.pCtx;
                                if (parserContext == null) {
                                    parserContext = new ParserContext();
                                    parserContext.getParserConfiguration().setAllImports(CompilerTools.getInjectedImports(variableResolverFactory));
                                }
                                this.newObjectOptimizer = object4.optimizeObjectCreation(parserContext, this.name, 0, this.name.length, object, object2, variableResolverFactory);
                                if (object4.getResultOptPass() == null) break block12;
                                this.egressType = object4.getEgressType();
                                object3 = object4.getResultOptPass();
                                v1 = null;
                                break block13;
                            }
                            catch (CompileException compileException) {
                                throw ErrorUtil.rewriteIfNeeded(compileException, this.expr, this.start);
                            }
                        }
                        v2 = null;
                        break block14;
                    }
                    catch (Throwable throwable22) {
                        break block15;
                    }
                }
                Object var8_10 = v1;
                OptimizerFactory.clearThreadAccessorOptimizer();
                return object3;
            }
            Object var8_11 = v2;
            OptimizerFactory.clearThreadAccessorOptimizer();
            return this.newObjectOptimizer.getValue(object, object2, variableResolverFactory);
        }
        Object var8_12 = null;
        OptimizerFactory.clearThreadAccessorOptimizer();
        throw throwable22;
    }

    public Object getReducedValue(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        try {
            if (this.typeDescr.isArray()) {
                Class clazz = ParseTools.findClass(variableResolverFactory, this.typeDescr.getClassName(), this.pCtx);
                int[] nArray = new int[this.typeDescr.getArrayLength()];
                ArraySize[] arraySizeArray = this.typeDescr.getArraySize();
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    nArray[i2] = DataConversion.convert(MVEL.eval(arraySizeArray[i2].value, object, variableResolverFactory), Integer.class);
                }
                return Array.newInstance(clazz, nArray);
            }
            String[] stringArray = ParseTools.captureContructorAndResidual(this.name, 0, this.name.length);
            List<char[]> list = ParseTools.parseMethodOrConstructor(stringArray[0].toCharArray());
            if (list != null) {
                Class clazz = ParseTools.findClass(variableResolverFactory, new String(ParseTools.subset(this.name, 0, ArrayTools.findFirst('(', 0, this.name.length, this.name))).trim(), this.pCtx);
                Object[] objectArray = new Object[list.size()];
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    objectArray[i3] = MVEL.eval(list.get(i3), object, variableResolverFactory);
                }
                Constructor constructor = ParseTools.getBestConstructorCandidate(objectArray, clazz, false);
                if (constructor == null) {
                    throw new CompileException("unable to find constructor for: " + clazz.getName(), this.expr, this.start);
                }
                for (int i4 = 0; i4 < objectArray.length; ++i4) {
                    objectArray[i4] = DataConversion.convert(objectArray[i4], constructor.getParameterTypes()[i4]);
                }
                if (stringArray.length > 1) {
                    return PropertyAccessor.get(stringArray[1], constructor.newInstance(objectArray), variableResolverFactory, object2, this.pCtx);
                }
                return constructor.newInstance(objectArray);
            }
            Constructor<?> constructor = Class.forName(this.typeDescr.getClassName(), true, this.pCtx.getParserConfiguration().getClassLoader()).getConstructor(EMPTYCLS);
            if (stringArray.length > 1) {
                return PropertyAccessor.get(stringArray[1], constructor.newInstance(new Object[0]), variableResolverFactory, object2, this.pCtx);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (CompileException compileException) {
            throw compileException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CompileException("unable to resolve class: " + classNotFoundException.getMessage(), this.expr, this.start, classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CompileException("cannot resolve constructor: " + noSuchMethodException.getMessage(), this.expr, this.start, noSuchMethodException);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            throw new CompileException("could not instantiate class: " + exception2.getMessage(), this.expr, this.start, exception2);
        }
    }

    private boolean isPrototypeFunction() {
        return this.pCtx.getFunctions().containsKey(this.typeDescr.getClassName());
    }

    private Object createPrototypalObject(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        Function function = this.pCtx.getFunction(this.typeDescr.getClassName());
        return function.getReducedValueAccelerated(object, object2, variableResolverFactory);
    }

    public TypeDescriptor getTypeDescr() {
        return this.typeDescr;
    }

    public Accessor getNewObjectOptimizer() {
        return this.newObjectOptimizer;
    }

    public static class NewObjectArray
    implements Accessor,
    Serializable {
        private ExecutableStatement[] sizes;
        private Class arrayType;

        public NewObjectArray(Class clazz, ExecutableStatement[] executableStatementArray) {
            this.arrayType = clazz;
            this.sizes = executableStatementArray;
        }

        public Object getValue(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
            int[] nArray = new int[this.sizes.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = DataConversion.convert(this.sizes[i2].getValue(object, object2, variableResolverFactory), Integer.class);
            }
            return Array.newInstance(this.arrayType, nArray);
        }

        public Object setValue(Object object, Object object2, VariableResolverFactory variableResolverFactory, Object object3) {
            return null;
        }

        public Class getKnownEgressType() {
            try {
                return Class.forName("[L" + this.arrayType.getName() + ";");
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }
}

