/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.debug;

import com.contrastsecurity.thirdparty.org.mvel2.ast.LineLabel;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.CompiledExpression;
import com.contrastsecurity.thirdparty.org.mvel2.debug.Debugger;
import com.contrastsecurity.thirdparty.org.mvel2.debug.Frame;
import com.contrastsecurity.thirdparty.org.mvel2.integration.VariableResolverFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebuggerContext {
    private Map<String, Set<Integer>> breakpoints = new HashMap<String, Set<Integer>>();
    private Debugger debugger;
    private int debuggerState = 0;

    public Map<String, Set<Integer>> getBreakpoints() {
        return this.breakpoints;
    }

    public void setBreakpoints(Map<String, Set<Integer>> map) {
        this.breakpoints = map;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public void setDebugger(Debugger debugger) {
        this.debugger = debugger;
    }

    public int getDebuggerState() {
        return this.debuggerState;
    }

    public void setDebuggerState(int n2) {
        this.debuggerState = n2;
    }

    public void registerBreakpoint(String string, int n2) {
        if (!this.breakpoints.containsKey(string)) {
            this.breakpoints.put(string, new HashSet());
        }
        this.breakpoints.get(string).add(n2);
    }

    public void removeBreakpoint(String string, int n2) {
        if (!this.breakpoints.containsKey(string)) {
            return;
        }
        this.breakpoints.get(string).remove(n2);
    }

    public void clearAllBreakpoints() {
        this.breakpoints.clear();
    }

    public boolean hasBreakpoints() {
        return this.breakpoints.size() != 0;
    }

    public boolean hasBreakpoint(LineLabel lineLabel) {
        return this.breakpoints.containsKey(lineLabel.getSourceFile()) && this.breakpoints.get(lineLabel.getSourceFile()).contains(lineLabel.getLineNumber());
    }

    public boolean hasBreakpoint(String string, int n2) {
        return this.breakpoints.containsKey(string) && this.breakpoints.get(string).contains(n2);
    }

    public boolean hasDebugger() {
        return this.debugger != null;
    }

    public int checkBreak(LineLabel lineLabel, VariableResolverFactory variableResolverFactory, CompiledExpression compiledExpression) {
        if (this.debuggerState == 1 || this.hasBreakpoint(lineLabel)) {
            if (this.debugger == null) {
                throw new RuntimeException("no debugger registered to handle breakpoint");
            }
            this.debuggerState = this.debugger.onBreak(new Frame(lineLabel, variableResolverFactory));
            return this.debuggerState;
        }
        return 0;
    }
}

