/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.http;

import com.contrastsecurity.http.FilterForm;
import com.contrastsecurity.http.RuleSeverity;
import com.contrastsecurity.http.ServerEnvironment;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ApplicationFilterForm
extends FilterForm {
    private String filterText = "";
    private String filterAppCode = "";
    private List<String> filterServers = new ArrayList<String>();
    private List<String> filterTechs = new ArrayList<String>();
    private List<String> filterTags = new ArrayList<String>();
    private List<String> filterCompliance;
    private List<String> filterLanguages = new ArrayList<String>();
    private EnumSet<ServerEnvironment> environment = null;
    private EnumSet<RuleSeverity> filterVulnSeverities = null;
    private boolean includeArchived = false;
    private boolean includeOnlyLicensed = false;
    private boolean includeMerged = true;
    private ApplicationQuickFilterType quickFilter = null;

    public ApplicationFilterForm() {
        this.filterCompliance = new ArrayList<String>();
    }

    public String getFilterText() {
        return this.filterText;
    }

    public void setFilterText(String filterText) {
        this.filterText = filterText;
    }

    public String getFilterAppCode() {
        return this.filterAppCode;
    }

    public void setFilterAppCode(String filterAppCode) {
        this.filterAppCode = filterAppCode;
    }

    public List<String> getFilterServers() {
        return this.filterServers;
    }

    public void setFilterServers(List<String> filterServers) {
        this.filterServers = filterServers;
    }

    public List<String> getFilterTechs() {
        return this.filterTechs;
    }

    public void setFilterTechs(List<String> filterTechs) {
        this.filterTechs = filterTechs;
    }

    public List<String> getFilterTags() {
        return this.filterTags;
    }

    public void setFilterTags(List<String> filterTags) {
        this.filterTags = filterTags;
    }

    public List<String> getFilterLanguages() {
        return this.filterLanguages;
    }

    public void setFilterLanguages(List<String> filterLanguages) {
        this.filterLanguages = filterLanguages;
    }

    public List<String> getFilterCompliance() {
        return this.filterCompliance;
    }

    public void setFilterCompliance(List<String> filterCompliance) {
        this.filterCompliance = filterCompliance;
    }

    public EnumSet<ServerEnvironment> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(EnumSet<ServerEnvironment> environment) {
        this.environment = environment;
    }

    public EnumSet<RuleSeverity> getFilterVulnSeverities() {
        return this.filterVulnSeverities;
    }

    public void setFilterVulnSeverities(EnumSet<RuleSeverity> filterVulnSeverities) {
        this.filterVulnSeverities = filterVulnSeverities;
    }

    public boolean getIncludeArchived() {
        return this.includeArchived;
    }

    public void setIncludeArchived(boolean includeArchived) {
        this.includeArchived = includeArchived;
    }

    public boolean isIncludeOnlyLicensed() {
        return this.includeOnlyLicensed;
    }

    public void setIncludeOnlyLicensed(boolean includeOnlyLicensed) {
        this.includeOnlyLicensed = includeOnlyLicensed;
    }

    public ApplicationQuickFilterType getQuickFilter() {
        return this.quickFilter;
    }

    public void setQuickFilter(ApplicationQuickFilterType quickFilter) {
        this.quickFilter = quickFilter;
    }

    public boolean isIncludeMerged() {
        return this.includeMerged;
    }

    public void setIncludeMerged(boolean includeMerged) {
        this.includeMerged = includeMerged;
    }

    @Override
    public String toString() {
        String formString = super.toString();
        ArrayList<String> filters = new ArrayList<String>();
        if (this.filterText != null && !this.filterText.isEmpty()) {
            filters.add("filterText=" + this.filterText);
        }
        if (this.filterAppCode != null && !this.filterAppCode.isEmpty()) {
            filters.add("filterAppCode=" + this.filterAppCode);
        }
        if (!this.filterServers.isEmpty()) {
            filters.add("filterServers=" + String.join((CharSequence)",", this.filterServers));
        }
        if (!this.filterTechs.isEmpty()) {
            filters.add("filterTechs=" + String.join((CharSequence)",", this.filterTechs));
        }
        if (!this.filterTags.isEmpty()) {
            filters.add("filterTags=" + String.join((CharSequence)",", this.filterTags));
        }
        if (!this.filterCompliance.isEmpty()) {
            filters.add("filterCompliance=" + String.join((CharSequence)",", this.filterCompliance));
        }
        if (!this.filterLanguages.isEmpty()) {
            filters.add("filterLanguages=" + String.join((CharSequence)",", this.filterLanguages));
        }
        if (this.environment != null && !this.environment.isEmpty()) {
            Set environments = this.environment.stream().map(Object::toString).collect(Collectors.toSet());
            filters.add("environments=" + String.join((CharSequence)",", environments));
        }
        if (this.filterVulnSeverities != null && !this.filterVulnSeverities.isEmpty()) {
            Set severities = this.filterVulnSeverities.stream().map(Object::toString).collect(Collectors.toSet());
            filters.add("filterVulnSeverities=" + String.join((CharSequence)",", severities));
        }
        filters.add("includeArchived=" + this.includeArchived);
        filters.add("includeOnlyLicensed=" + this.includeOnlyLicensed);
        filters.add("includeMerged=" + this.includeMerged);
        if (this.quickFilter != null) {
            filters.add("quickFilter=" + this.quickFilter.toString());
        }
        if (filters.isEmpty()) {
            return formString;
        }
        String result = String.join((CharSequence)"&", filters);
        if (formString != null && !formString.isEmpty()) {
            return formString + "&" + result;
        }
        return "?" + result;
    }

    public static enum ApplicationQuickFilterType {
        ALL("all"),
        ONLINE("online"),
        OFFLINE("offline"),
        MERGED("merged"),
        LICENSED("licensed"),
        UNLICENSED("unlicensed"),
        HIGH_RISK("high-risk"),
        INCOMPLETE_PROTECTION("incomplete-protection"),
        VIOLATION("violation"),
        ARCHIVED("archived");

        private final String name;

        private ApplicationQuickFilterType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum ApplicationExpandValues {
        COMPLIANCE_POLICY,
        COVERAGE,
        LICENSE,
        MODULES,
        PRODUCTION_PROTECTED,
        SCORES,
        SKIP_LINKS,
        TECHNOLOGIES,
        TRACE_BREAKDOWN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

