/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.http;

import com.contrastsecurity.http.RuleSeverity;
import com.contrastsecurity.http.ServerEnvironment;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;

public class TraceFilterForm {
    private String filterText = "";
    private Date startDate = null;
    private Date endDate = null;
    private List<String> filterTags = null;
    private EnumSet<RuleSeverity> severities = null;
    private List<String> status = null;
    private List<String> vulnTypes = null;
    private List<String> appVersionTags = null;
    private List<Long> serverIds = null;
    private EnumSet<ServerEnvironment> environments = null;
    private List<String> urls = null;
    private List<String> modules = null;
    private EnumSet<TraceExpandValue> expand = null;
    private int limit = -1;
    private int offset = -1;
    private String sort = "";

    public void setVulnTypes(List<String> vulnTypes) {
        this.vulnTypes = vulnTypes;
    }

    public String toQuery() throws UnsupportedEncodingException {
        ArrayList<String> filters = new ArrayList<String>();
        if (this.filterText != null && !this.filterText.isEmpty()) {
            filters.add(this.filterText);
        }
        if (this.expand != null && !this.expand.isEmpty()) {
            filters.add("expand=" + this.expand.stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        if (this.startDate != null) {
            filters.add("startDate=" + this.startDate.getTime());
        }
        if (this.endDate != null) {
            filters.add("endDate=" + this.endDate.getTime());
        }
        if (this.filterTags != null && !this.filterTags.isEmpty()) {
            filters.add("filterTags=" + String.join((CharSequence)",", this.filterTags));
        }
        if (this.severities != null && !this.severities.isEmpty()) {
            filters.add("severities=" + this.severities.stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        if (this.status != null) {
            filters.add("status=" + String.join((CharSequence)",", this.status));
        }
        if (this.vulnTypes != null && !this.vulnTypes.isEmpty()) {
            filters.add("vulnTypes=" + String.join((CharSequence)",", this.vulnTypes));
        }
        if (this.appVersionTags != null && !this.appVersionTags.isEmpty()) {
            filters.add("appVersionTags=" + URLEncoder.encode(String.join((CharSequence)",", this.appVersionTags), "UTF-8"));
        }
        if (this.environments != null && !this.environments.isEmpty()) {
            filters.add("environments=" + this.environments.stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        if (this.serverIds != null && !this.serverIds.isEmpty()) {
            filters.add("servers=" + this.serverIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
        }
        if (this.urls != null && !this.urls.isEmpty()) {
            filters.add("urls=" + String.join((CharSequence)",", this.urls));
        }
        if (this.modules != null && !this.modules.isEmpty()) {
            filters.add("modules=" + String.join((CharSequence)",", this.modules));
        }
        if (this.sort != null && !this.sort.isEmpty()) {
            filters.add("sort=" + this.sort);
        }
        if (this.limit > -1) {
            filters.add("limit=" + this.limit);
        }
        if (this.offset > -1) {
            filters.add("offset=" + this.offset);
        }
        if (!filters.isEmpty()) {
            return "?" + String.join((CharSequence)"&", filters);
        }
        return "";
    }

    public String toString() {
        try {
            return this.toQuery();
        }
        catch (UnsupportedEncodingException uee) {
            return "Unable to encode filters";
        }
    }

    public String getFilterText() {
        return this.filterText;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public List<String> getFilterTags() {
        return this.filterTags;
    }

    public EnumSet<RuleSeverity> getSeverities() {
        return this.severities;
    }

    public List<String> getStatus() {
        return this.status;
    }

    public List<String> getVulnTypes() {
        return this.vulnTypes;
    }

    public List<String> getAppVersionTags() {
        return this.appVersionTags;
    }

    public List<Long> getServerIds() {
        return this.serverIds;
    }

    public EnumSet<ServerEnvironment> getEnvironments() {
        return this.environments;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public List<String> getModules() {
        return this.modules;
    }

    public EnumSet<TraceExpandValue> getExpand() {
        return this.expand;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getSort() {
        return this.sort;
    }

    public void setFilterText(String filterText) {
        this.filterText = filterText;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setFilterTags(List<String> filterTags) {
        this.filterTags = filterTags;
    }

    public void setSeverities(EnumSet<RuleSeverity> severities) {
        this.severities = severities;
    }

    public void setStatus(List<String> status) {
        this.status = status;
    }

    public void setAppVersionTags(List<String> appVersionTags) {
        this.appVersionTags = appVersionTags;
    }

    public void setServerIds(List<Long> serverIds) {
        this.serverIds = serverIds;
    }

    public void setEnvironments(EnumSet<ServerEnvironment> environments) {
        this.environments = environments;
    }

    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    public void setModules(List<String> modules) {
        this.modules = modules;
    }

    public void setExpand(EnumSet<TraceExpandValue> expand) {
        this.expand = expand;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public static enum TraceExpandValue {
        CARD,
        EVENTS,
        NOTES,
        REQUEST,
        APPLICATION,
        SERVERS;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum LibrariesExpandValues {
        VULNS;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum ApplicationExpandValues {
        SCORES,
        TRACE_BREAKDOWN,
        LICENSE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

