/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.models;

import com.contrastsecurity.exceptions.InvalidConversionException;
import com.contrastsecurity.models.FreeformMetadata;
import com.contrastsecurity.models.NumericMetadata;
import com.contrastsecurity.models.PointOfContactMetadata;
import com.google.gson.annotations.SerializedName;

public abstract class MetadataEntity {
    protected MetadataType type;
    @SerializedName(value="fieldName")
    protected String fieldName;

    public MetadataType getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = MetadataType.valueOf(type);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public FreeformMetadata getAsFreeformMetadata() throws InvalidConversionException {
        if (this.type == MetadataType.STRING) {
            return (FreeformMetadata)this;
        }
        throw new InvalidConversionException(this.type.toString(), MetadataType.STRING.toString());
    }

    public NumericMetadata getAsNumericMetadata() throws InvalidConversionException {
        if (this.type == MetadataType.NUMERIC) {
            return (NumericMetadata)this;
        }
        throw new InvalidConversionException(this.type.toString(), MetadataType.NUMERIC.toString());
    }

    public PointOfContactMetadata getAsPointOfContactMetadata() throws InvalidConversionException {
        if (this.type == MetadataType.POINT_OF_CONTACT) {
            return (PointOfContactMetadata)this;
        }
        throw new InvalidConversionException(this.type.toString(), MetadataType.POINT_OF_CONTACT.toString());
    }

    public static enum MetadataType {
        STRING,
        NUMERIC,
        POINT_OF_CONTACT;


        public String toString() {
            return this.name().toUpperCase();
        }
    }
}

