/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.sdk.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;

public final class GsonFactory {
    public static GsonBuilder builder() {
        return new GsonBuilder().registerTypeAdapter(Instant.class, (Object)new InstantTypeAdapter().nullSafe());
    }

    public static Gson create() {
        return GsonFactory.builder().create();
    }

    private GsonFactory() {
    }

    private static final class InstantTypeAdapter
    extends TypeAdapter<Instant> {
        private InstantTypeAdapter() {
        }

        public void write(JsonWriter writer, Instant value) throws IOException {
            String formatted = DateTimeFormatter.ISO_INSTANT.format(value);
            writer.value(formatted);
        }

        public Instant read(JsonReader reader) throws IOException {
            String rfc3339 = reader.nextString();
            TemporalAccessor accessor = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(rfc3339);
            return Instant.from(accessor);
        }
    }
}

