/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.sdk.internal;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class URIBuilder {
    private final List<String> segments = new ArrayList<String>();
    private final Map<String, String> query = new HashMap<String, String>();

    public URIBuilder appendPathSegments(String ... segments) {
        for (String segment : segments) {
            Objects.requireNonNull(segment);
        }
        this.segments.addAll(Arrays.asList(segments));
        return this;
    }

    public URIBuilder appendQueryParam(String name, String value) {
        if (Objects.requireNonNull(name).isEmpty()) {
            throw new IllegalArgumentException("Name cannot be empty");
        }
        this.query.put(name, value);
        return this;
    }

    public URIBuilder appendQueryParam(String name, boolean value) {
        return this.appendQueryParam(name, String.valueOf(value));
    }

    public String toURIString() {
        String path = "/" + this.segments.stream().map(URIBuilder::encode).collect(Collectors.joining("/"));
        String query = this.query.entrySet().stream().map(entry -> URIBuilder.encode((String)entry.getKey()) + "=" + URIBuilder.encode((String)entry.getValue())).collect(Collectors.joining("&"));
        return query.isEmpty() ? path : path + "?" + query;
    }

    public String toString() {
        return this.toURIString();
    }

    private static String encode(String s) {
        try {
            return URLEncoder.encode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("This should never happen", e);
        }
    }
}

