/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.sdk.scan;

import com.contrastsecurity.exceptions.HttpResponseException;
import com.contrastsecurity.exceptions.ServerResponseException;
import com.contrastsecurity.sdk.ContrastSDK;
import com.contrastsecurity.sdk.internal.URIBuilder;
import com.contrastsecurity.sdk.scan.AutoValue_CodeArtifactInner;
import com.contrastsecurity.sdk.scan.CodeArtifactClient;
import com.contrastsecurity.sdk.scan.CodeArtifactInner;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;

final class CodeArtifactClientImpl
implements CodeArtifactClient {
    private final ContrastSDK contrast;
    private final Gson gson;
    private final String organizationId;
    private static final String CRLF = "\r\n";

    CodeArtifactClientImpl(ContrastSDK contrast, Gson gson, String organizationId) {
        this.contrast = Objects.requireNonNull(contrast);
        this.gson = Objects.requireNonNull(gson);
        this.organizationId = Objects.requireNonNull(organizationId);
    }

    @Override
    public CodeArtifactInner upload(String projectId, Path file) throws IOException {
        CodeArtifactInner codeArtifactInner;
        String uri = this.contrast.getRestApiURL() + new URIBuilder().appendPathSegments("sast", "organizations", this.organizationId, "projects", projectId, "code-artifacts").toURIString();
        String boundary = "ContrastFormBoundary" + ThreadLocalRandom.current().nextLong();
        String header = "--" + boundary + CRLF + "Content-Disposition: form-data; name=\"filename\"; filename=\"" + file.getFileName().toString() + '\"' + CRLF + "Content-Type: " + CodeArtifactClientImpl.determineMime(file) + CRLF + "Content-Transfer-Encoding: binary" + CRLF + CRLF;
        String footer = "\r\n--" + boundary + "--" + CRLF;
        long contentLength = (long)header.length() + Files.size(file) + (long)footer.length();
        HttpURLConnection connection = this.contrast.makeConnection(uri, "POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        connection.setFixedLengthStreamingMode(contentLength);
        try (OutputStream os = connection.getOutputStream();
             PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(os, StandardCharsets.US_ASCII), true);){
            writer.append(header).flush();
            Files.copy(file, os);
            os.flush();
            writer.append(footer).flush();
        }
        int code = connection.getResponseCode();
        if (code != 200 && code != 201) {
            throw HttpResponseException.fromConnection(connection, "Failed to upload code artifact to Contrast Scan");
        }
        InputStreamReader reader = new InputStreamReader(connection.getInputStream());
        try {
            codeArtifactInner = (CodeArtifactInner)this.gson.fromJson((Reader)reader, AutoValue_CodeArtifactInner.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonParseException e) {
                throw new ServerResponseException("Failed to parse Contrast API response", e);
            }
        }
        ((Reader)reader).close();
        return codeArtifactInner;
    }

    static String determineMime(Path file) throws IOException {
        String contentType = Files.probeContentType(file);
        if (contentType != null) {
            return contentType;
        }
        String name = file.getFileName().toString();
        if (name.endsWith(".jar") || name.endsWith(".war") || name.endsWith(".ear")) {
            return "application/java-archive";
        }
        return "application/octet-stream";
    }
}

