/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.sdk.scan;

import com.contrastsecurity.sdk.scan.CodeArtifact;
import com.contrastsecurity.sdk.scan.CodeArtifactClient;
import com.contrastsecurity.sdk.scan.CodeArtifactImpl;
import com.contrastsecurity.sdk.scan.CodeArtifactInner;
import com.contrastsecurity.sdk.scan.CodeArtifacts;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;

final class CodeArtifactsImpl
implements CodeArtifacts {
    private final CodeArtifactClient client;
    private final String projectId;

    CodeArtifactsImpl(CodeArtifactClient client, String projectId) {
        this.client = client;
        this.projectId = projectId;
    }

    @Override
    public CodeArtifact upload(Path file, String name) throws IOException {
        CodeArtifactInner inner = this.client.upload(this.projectId, file);
        return new CodeArtifactImpl(inner);
    }

    @Override
    public CodeArtifact upload(Path file) throws IOException {
        return this.upload(file, file.getFileName().toString());
    }

    static final class Factory
    implements CodeArtifacts.Factory {
        private final CodeArtifactClient client;

        Factory(CodeArtifactClient client) {
            this.client = Objects.requireNonNull(client);
        }

        @Override
        public CodeArtifacts create(String projectId) {
            return new CodeArtifactsImpl(this.client, projectId);
        }
    }
}

