/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.sdk.scan;

import com.contrastsecurity.exceptions.ContrastException;
import com.contrastsecurity.exceptions.ServerResponseException;
import com.contrastsecurity.http.HttpMethod;
import com.contrastsecurity.http.MediaType;
import com.contrastsecurity.sdk.ContrastSDK;
import com.contrastsecurity.sdk.internal.URIBuilder;
import com.contrastsecurity.sdk.scan.AutoValue_ProjectInner;
import com.contrastsecurity.sdk.scan.ProjectClient;
import com.contrastsecurity.sdk.scan.ProjectCreate;
import com.contrastsecurity.sdk.scan.ProjectInner;
import com.contrastsecurity.sdk.scan.ProjectsQuery;
import com.contrastsecurity.sdk.scan.ScanPagedResult;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import java.util.Optional;

final class ProjectClientImpl
implements ProjectClient {
    private final ContrastSDK contrast;
    private final Gson gson;
    private final String organizationId;

    ProjectClientImpl(ContrastSDK contrast, Gson gson, String organizationId) {
        this.contrast = Objects.requireNonNull(contrast);
        this.gson = Objects.requireNonNull(gson);
        this.organizationId = Objects.requireNonNull(organizationId);
    }

    @Override
    public ProjectInner create(ProjectCreate create) throws IOException {
        ProjectInner projectInner;
        String path = new URIBuilder().appendPathSegments("sast", "organizations", this.organizationId, "projects").toURIString();
        String json = this.gson.toJson((Object)create);
        InputStreamReader reader = new InputStreamReader(this.contrast.makeRequestWithBody(HttpMethod.POST, path, json, MediaType.JSON));
        try {
            projectInner = (ProjectInner)this.gson.fromJson((Reader)reader, AutoValue_ProjectInner.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonParseException e) {
                throw new ServerResponseException("Failed to parse Contrast API response", e);
            }
        }
        ((Reader)reader).close();
        return projectInner;
    }

    @Override
    public Optional<ProjectInner> findByName(String name) throws IOException {
        ScanPagedResult page;
        ProjectsQuery query = ProjectsQuery.builder().name(name).unique(true).build();
        String uri = new URIBuilder().appendPathSegments("sast", "organizations", this.organizationId, "projects").appendQueryParam("name", query.name()).appendQueryParam("unique", query.unique()).toURIString();
        try (InputStreamReader reader = new InputStreamReader(this.contrast.makeRequest(HttpMethod.GET, uri));){
            page = (ScanPagedResult)this.gson.fromJson((Reader)reader, new TypeToken<ScanPagedResult<AutoValue_ProjectInner>>(){}.getType());
        }
        catch (JsonParseException e) {
            throw new ServerResponseException("Failed to parse Contrast API response", e);
        }
        if (page.getTotalElements() > 1) {
            throw new ContrastException("Expected Contrast to return exactly one project with the given name, or no projects, but returned " + page.getTotalElements() + " projects");
        }
        return page.getTotalElements() == 1 ? Optional.of((ProjectInner)page.getContent().get(0)) : Optional.empty();
    }
}

