/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.sdk.scan;

import com.contrastsecurity.sdk.scan.CodeArtifacts;
import com.contrastsecurity.sdk.scan.Project;
import com.contrastsecurity.sdk.scan.ProjectClient;
import com.contrastsecurity.sdk.scan.ProjectCreate;
import com.contrastsecurity.sdk.scan.ProjectInner;
import com.contrastsecurity.sdk.scan.Scans;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Objects;

final class ProjectImpl
implements Project {
    private final CodeArtifacts.Factory codeArtifactsFactory;
    private final Scans.Factory scansFactory;
    private final ProjectInner inner;

    ProjectImpl(CodeArtifacts.Factory codeArtifactsFactory, Scans.Factory scansFactory, ProjectInner inner) {
        this.codeArtifactsFactory = codeArtifactsFactory;
        this.scansFactory = scansFactory;
        this.inner = Objects.requireNonNull(inner);
    }

    @Override
    public String id() {
        return this.inner.id();
    }

    @Override
    public String organizationId() {
        return this.inner.organizationId();
    }

    @Override
    public String name() {
        return this.inner.name();
    }

    @Override
    public boolean archived() {
        return this.inner.archived();
    }

    @Override
    public String language() {
        return this.inner.language();
    }

    @Override
    public int critical() {
        return this.inner.critical();
    }

    @Override
    public int high() {
        return this.inner.high();
    }

    @Override
    public int medium() {
        return this.inner.medium();
    }

    @Override
    public int low() {
        return this.inner.low();
    }

    @Override
    public int note() {
        return this.inner.note();
    }

    @Override
    public Instant lastScanTime() {
        return this.inner.lastScanTime();
    }

    @Override
    public int completedScans() {
        return this.inner.completedScans();
    }

    @Override
    public String lastScanId() {
        return this.inner.lastScanId();
    }

    @Override
    public Collection<String> includeNamespaceFilters() {
        return this.inner.includeNamespaceFilters();
    }

    @Override
    public Collection<String> excludeNamespaceFilters() {
        return this.inner.excludeNamespaceFilters();
    }

    @Override
    public CodeArtifacts codeArtifacts() {
        return this.codeArtifactsFactory.create(this.id());
    }

    @Override
    public Scans scans() {
        return this.scansFactory.create(this.id());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectImpl project = (ProjectImpl)o;
        return this.inner.equals(project.inner);
    }

    public int hashCode() {
        return Objects.hash(this.inner);
    }

    public String toString() {
        return this.inner.toString();
    }

    static final class Definition
    implements Project.Definition {
        private final ProjectClient client;
        private final CodeArtifacts.Factory codeArtifactsFactory;
        private final Scans.Factory scansFactory;
        private final ProjectCreate.Builder builder = ProjectCreate.builder();

        Definition(ProjectClient client, CodeArtifacts.Factory codeArtifactsFactory, Scans.Factory scansFactory) {
            this.client = Objects.requireNonNull(client);
            this.codeArtifactsFactory = Objects.requireNonNull(codeArtifactsFactory);
            this.scansFactory = Objects.requireNonNull(scansFactory);
        }

        @Override
        public Project.Definition withName(String name) {
            this.builder.name(name);
            return this;
        }

        @Override
        public Project.Definition withLanguage(String language) {
            this.builder.language(language);
            return this;
        }

        @Override
        public Project.Definition withIncludeNamespaceFilters(Collection<String> filters) {
            this.builder.includeNamespaceFilters(filters);
            return this;
        }

        @Override
        public Project.Definition withExcludeNamespaceFilters(Collection<String> filters) {
            this.builder.excludeNamespaceFilters(filters);
            return this;
        }

        @Override
        public Project create() throws IOException {
            ProjectCreate create = this.builder.build();
            ProjectInner inner = this.client.create(create);
            return new ProjectImpl(this.codeArtifactsFactory, this.scansFactory, inner);
        }
    }
}

