/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.sdk.scan;

import com.contrastsecurity.exceptions.ServerResponseException;
import com.contrastsecurity.http.HttpMethod;
import com.contrastsecurity.http.MediaType;
import com.contrastsecurity.sdk.ContrastSDK;
import com.contrastsecurity.sdk.internal.URIBuilder;
import com.contrastsecurity.sdk.scan.AutoValue_ScanInner;
import com.contrastsecurity.sdk.scan.AutoValue_ScanSummaryInner;
import com.contrastsecurity.sdk.scan.ScanClient;
import com.contrastsecurity.sdk.scan.ScanCreate;
import com.contrastsecurity.sdk.scan.ScanInner;
import com.contrastsecurity.sdk.scan.ScanSummaryInner;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;

final class ScanClientImpl
implements ScanClient {
    private final ContrastSDK contrast;
    private final Gson gson;
    private final String organizationId;

    ScanClientImpl(ContrastSDK contrast, Gson gson, String organizationId) {
        this.contrast = Objects.requireNonNull(contrast);
        this.gson = Objects.requireNonNull(gson);
        this.organizationId = Objects.requireNonNull(organizationId);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ScanInner get(String projectId, String scanId) throws IOException {
        String uri = new URIBuilder().appendPathSegments("sast", "organizations", this.organizationId, "projects", projectId, "scans", scanId).toURIString();
        try (InputStream is = this.contrast.makeRequest(HttpMethod.GET, uri);){
            ScanInner scanInner;
            try (InputStreamReader reader = new InputStreamReader(is);){
                scanInner = (ScanInner)this.gson.fromJson((Reader)reader, AutoValue_ScanInner.class);
            }
            return scanInner;
        }
        catch (JsonParseException e) {
            throw new ServerResponseException("Failed to parse Contrast API response", e);
        }
    }

    @Override
    public ScanInner create(String projectId, ScanCreate create) throws IOException {
        ScanInner scanInner;
        String uri = new URIBuilder().appendPathSegments("sast", "organizations", this.organizationId, "projects", projectId, "scans").toURIString();
        String json = this.gson.toJson((Object)create);
        InputStreamReader reader = new InputStreamReader(this.contrast.makeRequestWithBody(HttpMethod.POST, uri, json, MediaType.JSON));
        try {
            scanInner = (ScanInner)this.gson.fromJson((Reader)reader, AutoValue_ScanInner.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonParseException e) {
                throw new ServerResponseException("Failed to parse Contrast API response", e);
            }
        }
        ((Reader)reader).close();
        return scanInner;
    }

    @Override
    public InputStream getSarif(String projectId, String scanId) throws IOException {
        String uri = new URIBuilder().appendPathSegments("sast", "organizations", this.organizationId, "projects", projectId, "scans", scanId, "raw-output").toURIString();
        return this.contrast.makeRequest(HttpMethod.GET, uri);
    }

    @Override
    public ScanSummaryInner getSummary(String projectId, String scanId) throws IOException {
        ScanSummaryInner scanSummaryInner;
        String uri = new URIBuilder().appendPathSegments("sast", "organizations", this.organizationId, "projects", projectId, "scans", scanId, "summary").toURIString();
        InputStreamReader reader = new InputStreamReader(this.contrast.makeRequest(HttpMethod.GET, uri));
        try {
            scanSummaryInner = (ScanSummaryInner)this.gson.fromJson((Reader)reader, AutoValue_ScanSummaryInner.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonParseException e) {
                throw new ServerResponseException("Failed to parse Contrast API response", e);
            }
        }
        ((Reader)reader).close();
        return scanSummaryInner;
    }
}

