/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.sdk.scan;

import com.contrastsecurity.sdk.scan.CodeArtifact;
import com.contrastsecurity.sdk.scan.Scan;
import com.contrastsecurity.sdk.scan.ScanClient;
import com.contrastsecurity.sdk.scan.ScanCreate;
import com.contrastsecurity.sdk.scan.ScanException;
import com.contrastsecurity.sdk.scan.ScanInner;
import com.contrastsecurity.sdk.scan.ScanStatus;
import com.contrastsecurity.sdk.scan.ScanSummary;
import com.contrastsecurity.sdk.scan.ScanSummaryImpl;
import com.contrastsecurity.sdk.scan.ScanSummaryInner;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

final class ScanImpl
implements Scan {
    private final ScanClient client;
    private final ScanInner inner;
    private static final Duration POLL_INTERVAL = Duration.ofSeconds(10L);

    ScanImpl(ScanClient client, ScanInner inner) {
        this.client = Objects.requireNonNull(client);
        this.inner = Objects.requireNonNull(inner);
    }

    @Override
    public String id() {
        return this.inner.id();
    }

    @Override
    public String projectId() {
        return this.inner.projectId();
    }

    @Override
    public String organizationId() {
        return this.inner.organizationId();
    }

    @Override
    public ScanStatus status() {
        return this.inner.status();
    }

    @Override
    public String errorMessage() {
        return this.inner.errorMessage();
    }

    @Override
    public boolean isFinished() {
        return this.inner.status() == ScanStatus.FAILED || this.inner.status() == ScanStatus.COMPLETED || this.inner.status() == ScanStatus.CANCELLED;
    }

    @Override
    public CompletionStage<Scan> await(ScheduledExecutorService scheduler) {
        return this.await(scheduler, POLL_INTERVAL);
    }

    CompletionStage<Scan> await(ScheduledExecutorService scheduler, Duration interval) {
        return this.await(scheduler, scheduler, interval);
    }

    private CompletionStage<Scan> await(ScheduledExecutorService scheduler, Executor executor, Duration interval) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.refresh();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, executor).thenCompose(scan -> {
            switch (scan.status()) {
                case FAILED: {
                    throw new ScanException((Scan)scan, scan.errorMessage());
                }
                case CANCELLED: {
                    throw new ScanException((Scan)scan, "Canceled");
                }
                case COMPLETED: {
                    return CompletableFuture.completedFuture(scan);
                }
            }
            Executor delayedExecutor = r -> scheduler.schedule(r, interval.toMillis(), TimeUnit.MILLISECONDS);
            return this.await(scheduler, delayedExecutor, interval);
        });
    }

    @Override
    public InputStream sarif() throws IOException {
        if (!this.isFinished()) {
            throw new IllegalStateException("Scan is not yet finished");
        }
        return this.client.getSarif(this.inner.projectId(), this.inner.id());
    }

    @Override
    public void saveSarif(Path file) throws IOException {
        try (InputStream is = this.sarif();){
            Files.copy(is, file, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    @Override
    public ScanSummary summary() throws IOException {
        if (!this.isFinished()) {
            throw new IllegalStateException("Scan is not yet finished");
        }
        ScanSummaryInner inner = this.client.getSummary(this.inner.projectId(), this.inner.id());
        return new ScanSummaryImpl(inner);
    }

    @Override
    public Scan refresh() throws IOException {
        ScanInner inner = this.client.get(this.inner.projectId(), this.inner.id());
        return inner.equals(this.inner) ? this : new ScanImpl(this.client, inner);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanImpl scan = (ScanImpl)o;
        return this.inner.equals(scan.inner);
    }

    public int hashCode() {
        return Objects.hash(this.inner);
    }

    public String toString() {
        return this.inner.toString();
    }

    static final class Definition
    implements Scan.Definition {
        private final transient ScanClient client;
        private final transient String projectId;
        private String codeArtifactId;
        private String label;

        Definition(ScanClient client, String projectId) {
            this.client = Objects.requireNonNull(client);
            this.projectId = Objects.requireNonNull(projectId);
        }

        @Override
        public Scan.Definition withExistingCodeArtifact(String id) {
            this.codeArtifactId = Objects.requireNonNull(id);
            return this;
        }

        @Override
        public Scan.Definition withExistingCodeArtifact(CodeArtifact codeArtifact) {
            return this.withExistingCodeArtifact(codeArtifact.id());
        }

        @Override
        public Scan.Definition withLabel(String label) {
            this.label = Objects.requireNonNull(label);
            return this;
        }

        @Override
        public Scan create() throws IOException {
            ScanCreate create = ScanCreate.of(this.codeArtifactId, this.label);
            ScanInner inner = this.client.create(this.projectId, create);
            return new ScanImpl(this.client, inner);
        }
    }
}

