/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.sdk.scan;

import com.contrastsecurity.sdk.scan.Scan;
import com.contrastsecurity.sdk.scan.ScanClient;
import com.contrastsecurity.sdk.scan.ScanImpl;
import com.contrastsecurity.sdk.scan.ScanInner;
import com.contrastsecurity.sdk.scan.ScanSummary;
import com.contrastsecurity.sdk.scan.ScanSummaryImpl;
import com.contrastsecurity.sdk.scan.ScanSummaryInner;
import com.contrastsecurity.sdk.scan.Scans;
import java.io.IOException;
import java.util.Objects;

final class ScansImpl
implements Scans {
    private final ScanClient client;
    private final String projectId;

    ScansImpl(ScanClient client, String projectId) {
        this.client = Objects.requireNonNull(client);
        this.projectId = Objects.requireNonNull(projectId);
    }

    @Override
    public Scan.Definition define() {
        return new ScanImpl.Definition(this.client, this.projectId);
    }

    @Override
    public Scan get(String id) throws IOException {
        ScanInner inner = this.client.get(this.projectId, id);
        return new ScanImpl(this.client, inner);
    }

    @Override
    public ScanSummary summary(String id) throws IOException {
        ScanSummaryInner inner = this.client.getSummary(this.projectId, id);
        return new ScanSummaryImpl(inner);
    }

    static final class Factory
    implements Scans.Factory {
        private final ScanClient client;

        Factory(ScanClient client) {
            this.client = Objects.requireNonNull(client);
        }

        @Override
        public Scans create(String projectId) {
            return new ScansImpl(this.client, projectId);
        }
    }
}

