/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.concurrent;

import com.conversantmedia.util.concurrent.Condition;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;

abstract class AbstractCondition
implements Condition {
    private final ReentrantLock queueLock = new ReentrantLock();
    private final java.util.concurrent.locks.Condition condition = this.queueLock.newCondition();

    AbstractCondition() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitNanos(long timeout) throws InterruptedException {
        long remaining = timeout;
        this.queueLock.lock();
        try {
            while (this.test() && remaining > 0L) {
                remaining = this.condition.awaitNanos(remaining);
            }
        }
        finally {
            this.queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void await() throws InterruptedException {
        this.queueLock.lock();
        try {
            while (this.test()) {
                this.condition.await();
            }
        }
        finally {
            this.queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signal() {
        this.queueLock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.queueLock.unlock();
        }
    }

    static int progressiveYield(int n) {
        if (n > 100) {
            if (n < 1000) {
                if ((n & 7) == 0) {
                    LockSupport.parkNanos(50L);
                }
            } else if (n < 2000) {
                if ((n & 3) == 0) {
                    Thread.yield();
                }
            } else {
                Thread.yield();
                return n;
            }
        }
        return n + 1;
    }

    static boolean waitStatus(long timeout, TimeUnit unit, Condition condition) throws InterruptedException {
        long timeoutNanos = TimeUnit.NANOSECONDS.convert(timeout, unit);
        long expireTime = System.nanoTime() + timeoutNanos;
        while (condition.test()) {
            long now = System.nanoTime();
            if (now > expireTime) {
                return false;
            }
            condition.awaitNanos(expireTime - now - 50L);
        }
        return true;
    }
}

