/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.concurrent;

import com.conversantmedia.util.concurrent.Condition;
import com.conversantmedia.util.concurrent.MultithreadConcurrentQueue;
import com.conversantmedia.util.concurrent.PaddedAtomicInteger;
import com.conversantmedia.util.concurrent.PaddedInt;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.LockSupport;

abstract class AbstractWaitingCondition
implements Condition {
    private static final int MAX_WAITERS = 8;
    private static final int WAITER_MASK = 7;
    private static final long WAIT_TIME = 50L;
    private final AtomicReferenceArray<Thread> waiter = new AtomicReferenceArray(8);
    private final AtomicInteger waitCount = new PaddedAtomicInteger(0);
    private final PaddedInt waitCache = new PaddedInt(0);

    AbstractWaitingCondition() {
    }

    @Override
    public abstract boolean test();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitNanos(long timeout) throws InterruptedException {
        while (true) {
            try {
                int waitCount;
                int waitSequence = waitCount = this.waitCount.get();
                if (!this.waitCount.compareAndSet(waitCount, waitCount + 1)) continue;
                this.waitCache.value = waitCount + 1;
                long timeNow = System.nanoTime();
                long expires = timeNow + timeout;
                Thread t = Thread.currentThread();
                if (waitCount == 0) {
                    int spin = 0;
                    while (this.test() && expires > timeNow && !t.isInterrupted()) {
                        spin = MultithreadConcurrentQueue.progressiveYield(spin);
                        timeNow = System.nanoTime();
                    }
                    if (t.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    return;
                }
                int spin = 0;
                while (this.test() && !this.waiter.compareAndSet(waitSequence++ & 7, null, t) && expires > timeNow) {
                    if (spin < 2000) {
                        spin = MultithreadConcurrentQueue.progressiveYield(spin);
                    } else {
                        LockSupport.parkNanos(400L);
                    }
                    timeNow = System.nanoTime();
                }
                while (this.test() && this.waiter.get(waitSequence - 1 & 7) == t && expires > timeNow && !t.isInterrupted()) {
                    LockSupport.parkNanos(expires - timeNow >> 2);
                    timeNow = System.nanoTime();
                }
                if (t.isInterrupted()) {
                    while (!this.waiter.compareAndSet(waitSequence - 1 & 7, t, null) && this.waiter.get(0) == t) {
                        LockSupport.parkNanos(50L);
                    }
                    throw new InterruptedException();
                }
                return;
            }
            finally {
                this.waitCache.value = this.waitCount.decrementAndGet();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void await() throws InterruptedException {
        while (true) {
            try {
                int waitCount;
                int waitSequence = waitCount = this.waitCount.get();
                if (!this.waitCount.compareAndSet(waitCount, waitCount + 1)) continue;
                this.waitCache.value = waitCount + 1;
                Thread t = Thread.currentThread();
                if (waitCount == 0) {
                    int spin = 0;
                    while (this.test() && !t.isInterrupted()) {
                        spin = MultithreadConcurrentQueue.progressiveYield(spin);
                    }
                    if (t.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    return;
                }
                int spin = 0;
                while (this.test() && !this.waiter.compareAndSet(waitSequence++ & 7, null, t) && !t.isInterrupted()) {
                    if (spin < 2000) {
                        spin = MultithreadConcurrentQueue.progressiveYield(spin);
                        continue;
                    }
                    LockSupport.parkNanos(400L);
                }
                while (this.test() && this.waiter.get(waitSequence - 1 & 7) == t && !t.isInterrupted()) {
                    LockSupport.parkNanos(1000000L);
                }
                if (t.isInterrupted()) {
                    while (!this.waiter.compareAndSet(waitSequence - 1 & 7, t, null) && this.waiter.get(0) == t) {
                        LockSupport.parkNanos(50L);
                    }
                    throw new InterruptedException();
                }
                return;
            }
            finally {
                this.waitCache.value = this.waitCount.decrementAndGet();
                continue;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void signal() {
        block3: {
            if (this.waitCache.value <= 0 && (this.waitCache.value = this.waitCount.get()) <= 0) break block3;
            waitSequence = 0;
            do lbl-1000:
            // 3 sources

            {
                if ((t = this.waiter.get(waitSequence++ & 7)) == null) continue;
                if (this.waiter.compareAndSet(waitSequence - 1 & 7, t, null)) {
                    LockSupport.unpark(t);
                } else {
                    LockSupport.parkNanos(50L);
                }
                if ((waitSequence & 7) != 7 && (this.waitCache.value = this.waitCount.get()) != 0) ** GOTO lbl-1000
                return;
            } while ((waitSequence & 7) != 7 && (this.waitCache.value = this.waitCount.get()) != 0);
            return;
        }
    }
}

