/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.concurrent;

import com.conversantmedia.util.concurrent.ConcurrentQueue;
import com.conversantmedia.util.concurrent.Condition;
import com.conversantmedia.util.concurrent.PaddedAtomicLong;
import com.conversantmedia.util.concurrent.PaddedLong;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;

public class MultithreadConcurrentQueue<E>
implements ConcurrentQueue<E> {
    protected final int size;
    protected final long mask;
    protected final AtomicLong tail = new PaddedAtomicLong(0L);
    protected final PaddedLong tailCache = new PaddedLong(0L);
    protected final AtomicLong tailCursor = new PaddedAtomicLong(0L);
    protected final E[] buffer;
    protected final AtomicLong head = new PaddedAtomicLong(0L);
    protected final PaddedLong headCache = new PaddedLong(0L);
    protected final AtomicLong headCursor = new PaddedAtomicLong(0L);

    public MultithreadConcurrentQueue(int capacity) {
        int c;
        for (c = 1; c < capacity; c <<= 1) {
        }
        this.size = c;
        this.mask = (long)this.size - 1L;
        this.buffer = new Object[this.size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        int spin = 0;
        while (true) {
            long tailSeq;
            long queueStart;
            if (this.headCache.value > (queueStart = (tailSeq = this.tail.get()) - (long)this.size) || (this.headCache.value = this.head.get()) > queueStart) {
                long tailNext = tailSeq + 1L;
                if (this.tailCursor.compareAndSet(tailSeq, tailNext)) {
                    try {
                        int tailSlot = (int)(tailSeq & this.mask);
                        this.buffer[tailSlot] = e;
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        this.tail.set(tailNext);
                    }
                }
            } else {
                return false;
            }
            spin = MultithreadConcurrentQueue.progressiveYield(spin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        int spin = 0;
        while (true) {
            long head;
            if (this.tailCache.value > (head = this.head.get()) || (this.tailCache.value = this.tail.get()) > head) {
                long headNext = head + 1L;
                if (this.headCursor.compareAndSet(head, headNext)) {
                    try {
                        int pollSlot = (int)(head & this.mask);
                        E pollObj = this.buffer[pollSlot];
                        this.buffer[pollSlot] = null;
                        E e = pollObj;
                        return e;
                    }
                    finally {
                        this.head.set(headNext);
                    }
                }
            } else {
                return null;
            }
            spin = MultithreadConcurrentQueue.progressiveYield(spin);
        }
    }

    @Override
    public final E peek() {
        return this.buffer[(int)(this.head.get() & this.mask)];
    }

    @Override
    public int remove(E[] e) {
        int maxElements = e.length;
        int spin = 0;
        while (true) {
            long pollPos = this.head.get();
            int nToRead = Math.min((int)(this.tail.get() - pollPos), maxElements);
            if (nToRead > 0) {
                for (int i = 0; i < nToRead; ++i) {
                    int pollSlot = (int)(pollPos + (long)i & this.mask);
                    e[i] = this.buffer[pollSlot];
                }
                if (this.headCursor.compareAndSet(pollPos, pollPos + (long)nToRead)) {
                    this.head.set(pollPos + (long)nToRead);
                    return nToRead;
                }
            } else {
                return 0;
            }
            spin = MultithreadConcurrentQueue.progressiveYield(spin);
        }
    }

    @Override
    public final int size() {
        return (int)Math.max(this.tail.get() - this.head.get(), 0L);
    }

    @Override
    public int capacity() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.tail.get() == this.head.get();
    }

    @Override
    public void clear() {
        int spin = 0;
        while (true) {
            long head;
            if (this.headCursor.compareAndSet(head = this.head.get(), head + 1L)) {
                while (true) {
                    long tail;
                    if (this.tailCursor.compareAndSet(tail = this.tail.get(), tail + 1L)) {
                        for (int i = 0; i < this.buffer.length; ++i) {
                            this.buffer[i] = null;
                        }
                        this.head.set(tail + 1L);
                        this.tail.set(tail + 1L);
                        this.headCursor.set(tail + 1L);
                        return;
                    }
                    spin = MultithreadConcurrentQueue.progressiveYield(spin);
                }
            }
            spin = MultithreadConcurrentQueue.progressiveYield(spin);
        }
    }

    @Override
    public final boolean contains(Object o) {
        for (int i = 0; i < this.size(); ++i) {
            int slot = (int)(this.head.get() + (long)i & this.mask);
            if (this.buffer[slot] == null || !this.buffer[slot].equals(o)) continue;
            return true;
        }
        return false;
    }

    static int progressiveYield(int n) {
        if (n > 100) {
            if (n < 1000) {
                if ((n & 7) == 0) {
                    LockSupport.parkNanos(50L);
                }
            } else if (n < 2000) {
                if ((n & 3) == 0) {
                    Thread.yield();
                }
            } else {
                Thread.yield();
                return n;
            }
        }
        return n + 1;
    }

    static boolean waitStatus(long timeout, TimeUnit unit, Condition condition) throws InterruptedException {
        long timeoutNanos = TimeUnit.NANOSECONDS.convert(timeout, unit);
        long expireTime = System.nanoTime() + timeoutNanos;
        while (condition.test()) {
            long now = System.nanoTime();
            if (now > expireTime) {
                return false;
            }
            condition.awaitNanos(expireTime - now - 50L);
        }
        return true;
    }
}

