/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.Geometries;
import com.conveyal.gtfs.model.Stop;
import com.conveyal.gtfs.model.StopTime;
import com.conveyal.gtfs.model.Transfer;
import com.conveyal.gtfs.model.Trip;
import com.google.common.base.Strings;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.mapdb.Fun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CropGTFS {
    private static final Logger LOG = LoggerFactory.getLogger(CropGTFS.class);
    private static final String inputFile = "/Users/abyrd/geodata/nl/NL-2016-08-23.gtfs.zip";
    private static final String outputFile = "/Users/abyrd/geodata/nl/NL-2016-08-23-noplatforms-noshapes.gtfs.zip";
    private static final boolean MERGE_STATIONS = true;
    private static final boolean REMOVE_SHAPES = true;

    public static void main(String[] args) {
        StopTime stopTime;
        Object trip;
        GTFSFeed feed = GTFSFeed.fromFile(inputFile);
        HashSet<String> referencedTripIds = new HashSet<String>();
        HashSet<String> retainedTripIds = new HashSet<String>();
        Geometry bounds = Geometries.getNetherlandsWithoutTexel();
        System.out.println("Removing stops outside bounding box...");
        HashMap<String, String> stopIdReplacements = new HashMap<String, String>();
        Iterator<Stop> stopIterator = feed.stops.values().iterator();
        while (stopIterator.hasNext()) {
            Iterator stop = stopIterator.next();
            if (!Strings.isNullOrEmpty((String)((Stop)((Object)stop)).parent_station)) {
                stopIdReplacements.put(((Stop)((Object)stop)).stop_id, ((Stop)((Object)stop)).parent_station);
                stopIterator.remove();
                continue;
            }
            if (bounds.contains((Geometry)Geometries.geometryFactory.createPoint(new Coordinate(((Stop)((Object)stop)).stop_lon, ((Stop)((Object)stop)).stop_lat)))) continue;
            stopIterator.remove();
        }
        System.out.println("Replacing stop_ids in stop_times with those of their parent stations...");
        for (Fun.Tuple2 key : feed.stop_times.keySet()) {
            StopTime stopTime2 = (StopTime)feed.stop_times.get((Object)key);
            String replacementStopId = (String)stopIdReplacements.get(stopTime2.stop_id);
            if (replacementStopId == null) continue;
            stopTime2.stop_id = replacementStopId;
            feed.stop_times.put((Object)key, (Object)stopTime2);
        }
        System.out.println("Removing shapes table and removing shape IDs from trips...");
        feed.shape_points.clear();
        for (String tripId : feed.trips.keySet()) {
            trip = (Trip)feed.trips.get((Object)tripId);
            ((Trip)trip).shape_id = null;
            feed.trips.put((Object)tripId, trip);
        }
        System.out.println("Removing stop_times outside the bounding box and finding trips with two or more stop_times inside the bounding box...");
        Iterator stIterator = feed.stop_times.values().iterator();
        while (stIterator.hasNext()) {
            stopTime = (StopTime)stIterator.next();
            if (feed.stops.containsKey(stopTime.stop_id)) {
                if (referencedTripIds.contains(stopTime.trip_id)) {
                    retainedTripIds.add(stopTime.trip_id);
                    continue;
                }
                referencedTripIds.add(stopTime.trip_id);
                continue;
            }
            stIterator.remove();
        }
        System.out.println("Removing stoptimes for trips with less than two stop_times inside the bounding box...");
        stIterator = feed.stop_times.values().iterator();
        while (stIterator.hasNext()) {
            stopTime = (StopTime)stIterator.next();
            if (retainedTripIds.contains(stopTime.trip_id)) continue;
            stIterator.remove();
        }
        System.out.println("Removing trips that had less than two stop_times inside bounding box...");
        Iterator tripIterator = feed.trips.values().iterator();
        while (tripIterator.hasNext()) {
            trip = (Trip)tripIterator.next();
            if (retainedTripIds.contains(((Trip)trip).trip_id)) continue;
            tripIterator.remove();
        }
        System.out.println("Replacing stop_ids in transfers with those of their parent stations...");
        for (String key : feed.transfers.keySet()) {
            Transfer transfer = feed.transfers.get(key);
            String replacementStopId = (String)stopIdReplacements.get(transfer.from_stop_id);
            if (replacementStopId != null) {
                transfer.from_stop_id = replacementStopId;
            }
            if ((replacementStopId = (String)stopIdReplacements.get(transfer.to_stop_id)) != null) {
                transfer.to_stop_id = replacementStopId;
            }
            feed.transfers.put(key, transfer);
        }
        System.out.println("Filtering transfers for removed stops...");
        Iterator<Transfer> ti = feed.transfers.values().iterator();
        while (ti.hasNext()) {
            Transfer t = ti.next();
            if (feed.stops.containsKey(t.from_stop_id) && feed.stops.containsKey(t.to_stop_id)) continue;
            ti.remove();
        }
        System.out.println("Writing GTFS...");
        feed.toFile(outputFile);
        feed.close();
    }
}

