/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Pattern;
import com.conveyal.gtfs.model.Route;
import com.conveyal.gtfs.model.Stop;
import com.conveyal.gtfs.model.Trip;
import com.conveyal.gtfs.stats.FeedStats;
import com.conveyal.gtfs.stats.RouteStats;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;

public class FrequencySummary {
    private static final LocalTime[] windows = new LocalTime[]{LocalTime.of(6, 0), LocalTime.of(9, 0), LocalTime.of(16, 0), LocalTime.of(18, 0), LocalTime.of(22, 0)};
    private static final LocalDate date = LocalDate.of(2016, 8, 30);

    public static void main(String ... args) throws IOException {
        GTFSFeed feed = GTFSFeed.fromFile(args[0]);
        feed.findPatterns();
        FeedStats fs = new FeedStats(feed);
        RouteStats stats = new RouteStats(feed, fs);
        FileWriter writer = new FileWriter(new File(args[1]));
        writer.write("Route,AM Peak Frequency,Midday Frequency,PM Peak Frequency,Evening Frequency,AM Peak Speed,Midday Speed,PM Peak Speed,Evening Speed,Trips/Day,First trip,Last trip\n");
        for (String route_id : feed.routes.keySet()) {
            for (int direction_id : new int[]{0, 1}) {
                StringBuilder freq = new StringBuilder();
                StringBuilder speed = new StringBuilder();
                Route r = feed.routes.get(route_id);
                freq.append(r.route_short_name);
                freq.append(" ");
                freq.append(r.route_long_name);
                List<String> stops = feed.patterns.values().stream().filter((Predicate<Pattern>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$main$72(java.lang.String com.conveyal.gtfs.GTFSFeed int com.conveyal.gtfs.model.Pattern ), (Lcom/conveyal/gtfs/model/Pattern;)Z)((String)route_id, (GTFSFeed)feed, (int)direction_id)).sorted((Comparator<Pattern>)(Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$main$73(com.conveyal.gtfs.model.Pattern com.conveyal.gtfs.model.Pattern ), (Lcom/conveyal/gtfs/model/Pattern;Lcom/conveyal/gtfs/model/Pattern;)I)()).findFirst().get().orderedStops;
                Stop lastStop = feed.stops.get(stops.get(stops.size() - 1));
                freq.append(" towards ");
                freq.append(lastStop.stop_name);
                freq.append(",");
                for (int window = 0; window < windows.length - 1; ++window) {
                    int headwaySecs = stats.getHeadwayForRouteDirection(route_id, direction_id, date, windows[window], windows[window + 1]);
                    freq.append(headwaySecs > 0 ? Integer.valueOf(Math.round(headwaySecs / 60)) : "-");
                    freq.append(",");
                    double speedMs = stats.getSpeedForRouteDirection(route_id, direction_id, date, windows[window], windows[window + 1]);
                    speed.append(Double.isNaN(speedMs) ? "-" : Long.valueOf(Math.round(speedMs * 3600.0 / 1609.0)));
                    speed.append(",");
                }
                speed.append(stats.getTripsPerDateOfService(route_id).get(date).stream().filter(t -> t.direction_id == direction_id).count());
                speed.append(",");
                speed.append(stats.getStartTimeForRouteDirection(route_id, direction_id, date).format(DateTimeFormatter.ofPattern("K:mm a")));
                speed.append(",");
                speed.append(stats.getEndTimeForRouteDirection(route_id, direction_id, date).format(DateTimeFormatter.ofPattern("K:mm a")));
                writer.write(freq.toString());
                writer.write(speed.toString());
                writer.write("\n");
            }
        }
        writer.flush();
        writer.close();
    }

    private static /* synthetic */ int lambda$main$73(Pattern p1, Pattern p2) {
        return p1.orderedStops.size() - p2.orderedStops.size();
    }

    private static /* synthetic */ boolean lambda$main$72(String string, GTFSFeed gTFSFeed, int n, Pattern p) {
        return p.route_id.equals(string) && ((Trip)gTFSFeed.trips.get((Object)p.associatedTrips.get((int)0))).direction_id == n;
    }
}

