/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs;

import com.conveyal.gtfs.TripPatternKey;
import com.conveyal.gtfs.error.GTFSError;
import com.conveyal.gtfs.model.Agency;
import com.conveyal.gtfs.model.Calendar;
import com.conveyal.gtfs.model.CalendarDate;
import com.conveyal.gtfs.model.Fare;
import com.conveyal.gtfs.model.FareAttribute;
import com.conveyal.gtfs.model.FareRule;
import com.conveyal.gtfs.model.FeedInfo;
import com.conveyal.gtfs.model.Frequency;
import com.conveyal.gtfs.model.Pattern;
import com.conveyal.gtfs.model.Route;
import com.conveyal.gtfs.model.Service;
import com.conveyal.gtfs.model.Shape;
import com.conveyal.gtfs.model.ShapePoint;
import com.conveyal.gtfs.model.Stop;
import com.conveyal.gtfs.model.StopTime;
import com.conveyal.gtfs.model.Transfer;
import com.conveyal.gtfs.model.Trip;
import com.conveyal.gtfs.stats.FeedStats;
import com.conveyal.gtfs.util.Util;
import com.conveyal.gtfs.validator.DuplicateStopsValidator;
import com.conveyal.gtfs.validator.GTFSValidator;
import com.conveyal.gtfs.validator.HopSpeedsReasonableValidator;
import com.conveyal.gtfs.validator.MisplacedStopValidator;
import com.conveyal.gtfs.validator.NamesValidator;
import com.conveyal.gtfs.validator.OverlappingTripsValidator;
import com.conveyal.gtfs.validator.ReversedTripsValidator;
import com.conveyal.gtfs.validator.TripTimesValidator;
import com.conveyal.gtfs.validator.UnusedStopValidator;
import com.conveyal.gtfs.validator.service.GeoUtils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.ExecutionError;
import com.vividsolutions.jts.algorithm.ConvexHull;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.geotools.referencing.GeodeticCalculator;
import org.mapdb.BTreeMap;
import org.mapdb.Bind;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Fun;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GTFSFeed
implements Cloneable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(GTFSFeed.class);
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    private DB db;
    public String feedId = null;
    public final Map<String, Agency> agency;
    public final Map<String, FeedInfo> feedInfo;
    public final NavigableSet<Fun.Tuple2<String, Frequency>> frequencies;
    public final Map<String, Route> routes;
    public final Map<String, Stop> stops;
    public final Map<String, Transfer> transfers;
    public final BTreeMap<String, Trip> trips;
    public final Set<String> transitIds = new HashSet<String>();
    public long checksum;
    public final ConcurrentNavigableMap<Fun.Tuple2<String, Integer>, ShapePoint> shape_points;
    public final BTreeMap<Fun.Tuple2, StopTime> stop_times;
    public final NavigableSet<Fun.Tuple2<String, Fun.Tuple2>> stopStopTimeSet;
    public final ConcurrentMap<String, Long> stopCountByStopTime;
    public final NavigableSet<Fun.Tuple2<String, String>> tripsPerService;
    public final NavigableSet<Fun.Tuple2<String, String>> servicesPerDate;
    public final Map<String, Fare> fares;
    public final BTreeMap<String, Service> services;
    public final NavigableSet<GTFSError> errors;
    private transient STRtree spatialIndex;
    private transient Polygon convexHull;
    private transient Geometry mergedBuffers;
    GeometryFactory gf = new GeometryFactory();
    public final Map<String, Pattern> patterns;
    public final Map<String, String> tripPatternMap;
    private boolean loaded = false;
    public transient EventBus eventBus;

    public void loadFromFile(ZipFile zip, String fid) throws Exception {
        if (this.loaded) {
            throw new UnsupportedOperationException("Attempt to load GTFS into existing database");
        }
        this.checksum = zip.stream().mapToLong(ZipEntry::getCrc).reduce((l1, l2) -> l1 ^ l2).getAsLong();
        this.db.getAtomicLong("checksum").set(this.checksum);
        new FeedInfo.Loader(this).loadTable(zip);
        if (fid != null) {
            this.feedId = fid;
            LOG.info("Feed ID is undefined, pester maintainers to include a feed ID. Using file name {}.", (Object)this.feedId);
        } else if (this.feedId == null || this.feedId.isEmpty()) {
            this.feedId = new File(zip.getName()).getName().replaceAll("\\.zip$", "");
            LOG.info("Feed ID is undefined, pester maintainers to include a feed ID. Using file name {}.", (Object)this.feedId);
        } else {
            LOG.info("Feed ID is '{}'.", (Object)this.feedId);
        }
        this.db.getAtomicString("feed_id").set(this.feedId);
        new Agency.Loader(this).loadTable(zip);
        HashMap<String, Service> serviceTable = new HashMap<String, Service>();
        new Calendar.Loader(this, serviceTable).loadTable(zip);
        new CalendarDate.Loader(this, serviceTable).loadTable(zip);
        this.services.putAll(serviceTable);
        serviceTable = null;
        HashMap<String, Fare> fares = new HashMap<String, Fare>();
        new FareAttribute.Loader(this, fares).loadTable(zip);
        new FareRule.Loader(this, fares).loadTable(zip);
        this.fares.putAll(fares);
        fares = null;
        new Route.Loader(this).loadTable(zip);
        new ShapePoint.Loader(this).loadTable(zip);
        new Stop.Loader(this).loadTable(zip);
        new Transfer.Loader(this).loadTable(zip);
        new Trip.Loader(this).loadTable(zip);
        new Frequency.Loader(this).loadTable(zip);
        new StopTime.Loader(this).loadTable(zip);
        LOG.info("{} errors", (Object)this.errors.size());
        for (GTFSError error : this.errors) {
            LOG.info("{}", (Object)error);
        }
        LOG.info("Building stop to stop times index");
        Bind.histogram(this.stop_times, this.stopCountByStopTime, (key, stopTime) -> stopTime.stop_id);
        Bind.secondaryKeys(this.stop_times, this.stopStopTimeSet, (key, stopTime) -> new String[]{stopTime.stop_id});
        LOG.info("Building trips per service index");
        Bind.secondaryKeys(this.trips, this.tripsPerService, (key, trip) -> new String[]{trip.service_id});
        LOG.info("Building services per date index");
        Bind.secondaryKeys(this.services, this.servicesPerDate, (key, service) -> {
            LocalDate startDate = service.calendar != null ? LocalDate.parse(String.valueOf(service.calendar.start_date), dateFormatter) : (LocalDate)service.calendar_dates.keySet().stream().sorted().findFirst().get();
            LocalDate endDate = service.calendar != null ? LocalDate.parse(String.valueOf(service.calendar.end_date), dateFormatter) : (LocalDate)service.calendar_dates.keySet().stream().sorted().reduce((first, second) -> second).get();
            int daysOfService = (int)ChronoUnit.DAYS.between(startDate, endDate.plus(1L, ChronoUnit.DAYS));
            return (String[])IntStream.range(0, daysOfService).mapToObj(offset -> startDate.plusDays(offset)).filter(service::activeOn).map(date -> date.format(dateFormatter)).toArray(String[]::new);
        });
        this.loaded = true;
    }

    public void loadFromFile(ZipFile zip) throws Exception {
        this.loadFromFile(zip, null);
    }

    public void toFile(String file) {
        try {
            File out = new File(file);
            FileOutputStream os = new FileOutputStream(out);
            ZipOutputStream zip = new ZipOutputStream(os);
            if (!this.feedInfo.isEmpty()) {
                new FeedInfo.Writer(this).writeTable(zip);
            }
            new Agency.Writer(this).writeTable(zip);
            new Calendar.Writer(this).writeTable(zip);
            new CalendarDate.Writer(this).writeTable(zip);
            new FareAttribute.Writer(this).writeTable(zip);
            new FareRule.Writer(this).writeTable(zip);
            new Frequency.Writer(this).writeTable(zip);
            new Route.Writer(this).writeTable(zip);
            new Stop.Writer(this).writeTable(zip);
            new ShapePoint.Writer(this).writeTable(zip);
            new Transfer.Writer(this).writeTable(zip);
            new Trip.Writer(this).writeTable(zip);
            new StopTime.Writer(this).writeTable(zip);
            zip.close();
            LOG.info("GTFS file written");
        }
        catch (Exception e) {
            LOG.error("Error saving GTFS: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void validate(boolean repair, GTFSValidator ... validators) {
        long startValidation = System.currentTimeMillis();
        for (GTFSValidator validator : validators) {
            try {
                long startValidator = System.currentTimeMillis();
                validator.validate(this, repair);
                long endValidator = System.currentTimeMillis();
                long diff = endValidator - startValidator;
                LOG.info("{} finished in {} milliseconds.", (Object)validator.getClass().getSimpleName(), (Object)diff);
            }
            catch (Exception e) {
                LOG.error("Could not run {} validator.", (Object)validator.getClass().getSimpleName());
                e.printStackTrace();
            }
        }
        long endValidation = System.currentTimeMillis();
        long total = endValidation - startValidation;
        LOG.info("{} validators completed in {} milliseconds.", (Object)validators.length, (Object)total);
    }

    public void validate() {
        this.validate(false, new DuplicateStopsValidator(), new HopSpeedsReasonableValidator(), new MisplacedStopValidator(), new NamesValidator(), new OverlappingTripsValidator(), new ReversedTripsValidator(), new TripTimesValidator(), new UnusedStopValidator());
    }

    public void validateAndRepair() {
        this.validate(true, new DuplicateStopsValidator(), new HopSpeedsReasonableValidator(), new MisplacedStopValidator(), new NamesValidator(), new OverlappingTripsValidator(), new ReversedTripsValidator(), new TripTimesValidator(), new UnusedStopValidator());
    }

    public FeedStats calculateStats() {
        FeedStats feedStats = new FeedStats(this);
        return feedStats;
    }

    public static GTFSFeed fromFile(String file) {
        return GTFSFeed.fromFile(file, null);
    }

    public static GTFSFeed fromFile(String file, String feedId) {
        GTFSFeed feed = new GTFSFeed();
        try {
            ZipFile zip = new ZipFile(file);
            if (feedId == null) {
                feed.loadFromFile(zip);
            } else {
                feed.loadFromFile(zip, feedId);
            }
            zip.close();
            return feed;
        }
        catch (Exception e) {
            LOG.error("Error loading GTFS: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public boolean hasFeedInfo() {
        return !this.feedInfo.isEmpty();
    }

    public FeedInfo getFeedInfo() {
        return this.hasFeedInfo() ? this.feedInfo.values().iterator().next() : null;
    }

    public Iterable<StopTime> getOrderedStopTimesForTrip(String trip_id) {
        ConcurrentNavigableMap tripStopTimes = this.stop_times.subMap((Object)Fun.t2((Object)trip_id, null), (Object)Fun.t2((Object)trip_id, (Object)Fun.HI));
        return tripStopTimes.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRtree getSpatialIndex() {
        if (this.spatialIndex == null) {
            GTFSFeed gTFSFeed = this;
            synchronized (gTFSFeed) {
                if (this.spatialIndex == null) {
                    STRtree stopIndex = new STRtree();
                    for (Stop stop : this.stops.values()) {
                        try {
                            if (Double.isNaN(stop.stop_lat) || Double.isNaN(stop.stop_lon)) continue;
                            Coordinate stopCoord = new Coordinate(stop.stop_lat, stop.stop_lon);
                            stopIndex.insert(new Envelope(stopCoord), (Object)stop);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        stopIndex.build();
                        this.spatialIndex = stopIndex;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.spatialIndex;
    }

    public Shape getShape(String shape_id) {
        Shape shape = new Shape(this, shape_id);
        return shape.shape_dist_traveled.length > 0 ? shape : null;
    }

    public Iterable<StopTime> getInterpolatedStopTimesForTrip(String trip_id) throws FirstAndLastStopsDoNotHaveTimes {
        StopTime[] stopTimes = (StopTime[])StreamSupport.stream(this.getOrderedStopTimesForTrip(trip_id).spliterator(), false).map(st -> st.clone()).toArray(StopTime[]::new);
        if (stopTimes.length == 0) {
            return Collections.emptyList();
        }
        for (StopTime st2 : stopTimes) {
            if (st2.arrival_time != Integer.MIN_VALUE && st2.departure_time == Integer.MIN_VALUE) {
                st2.departure_time = st2.arrival_time;
            }
            if (st2.arrival_time != Integer.MIN_VALUE || st2.departure_time == Integer.MIN_VALUE) continue;
            st2.arrival_time = st2.departure_time;
        }
        if (stopTimes[0].departure_time == Integer.MIN_VALUE || stopTimes[stopTimes.length - 1].departure_time == Integer.MIN_VALUE) {
            throw new FirstAndLastStopsDoNotHaveTimes();
        }
        int startOfInterpolatedBlock = -1;
        for (int stopTime = 0; stopTime < stopTimes.length; ++stopTime) {
            if (stopTimes[stopTime].departure_time == Integer.MIN_VALUE && startOfInterpolatedBlock == -1) {
                startOfInterpolatedBlock = stopTime;
                continue;
            }
            if (stopTimes[stopTime].departure_time == Integer.MIN_VALUE || startOfInterpolatedBlock == -1) continue;
            int nInterpolatedStops = stopTime - startOfInterpolatedBlock;
            double totalLengthOfInterpolatedSection = 0.0;
            double[] lengthOfInterpolatedSections = new double[nInterpolatedStops];
            GeodeticCalculator calc = new GeodeticCalculator();
            int stopTimeToInterpolate = startOfInterpolatedBlock;
            int i = 0;
            while (stopTimeToInterpolate < stopTime) {
                Stop start = this.stops.get(stopTimes[stopTimeToInterpolate - 1].stop_id);
                Stop end = this.stops.get(stopTimes[stopTimeToInterpolate].stop_id);
                calc.setStartingGeographicPoint(start.stop_lon, start.stop_lat);
                calc.setDestinationGeographicPoint(end.stop_lon, end.stop_lat);
                double segLen = calc.getOrthodromicDistance();
                totalLengthOfInterpolatedSection += segLen;
                lengthOfInterpolatedSections[i] = segLen;
                ++stopTimeToInterpolate;
                ++i;
            }
            Stop start = this.stops.get(stopTimes[stopTime - 1].stop_id);
            Stop end = this.stops.get(stopTimes[stopTime].stop_id);
            calc.setStartingGeographicPoint(start.stop_lon, start.stop_lat);
            calc.setDestinationGeographicPoint(end.stop_lon, end.stop_lat);
            totalLengthOfInterpolatedSection += calc.getOrthodromicDistance();
            int departureBeforeInterpolation = stopTimes[startOfInterpolatedBlock - 1].departure_time;
            int arrivalAfterInterpolation = stopTimes[stopTime].arrival_time;
            int totalTime = arrivalAfterInterpolation - departureBeforeInterpolation;
            double lengthSoFar = 0.0;
            int stopTimeToInterpolate2 = startOfInterpolatedBlock;
            int i2 = 0;
            while (stopTimeToInterpolate2 < stopTime) {
                int time;
                stopTimes[stopTimeToInterpolate2].arrival_time = stopTimes[stopTimeToInterpolate2].departure_time = (time = (int)((double)departureBeforeInterpolation + (double)totalTime * ((lengthSoFar += lengthOfInterpolatedSections[i2]) / totalLengthOfInterpolatedSection)));
                ++stopTimeToInterpolate2;
                ++i2;
            }
            startOfInterpolatedBlock = -1;
        }
        return Arrays.asList(stopTimes);
    }

    public Collection<Frequency> getFrequencies(String trip_id) {
        return this.frequencies.subSet((Fun.Tuple2<String, Frequency>)new Fun.Tuple2((Object)trip_id, null), (Fun.Tuple2<String, Frequency>)new Fun.Tuple2((Object)trip_id, Fun.HI)).stream().map(t2 -> (Frequency)((Fun.Tuple2)t2).b).collect(Collectors.toList());
    }

    public List<String> getOrderedStopListForTrip(String trip_id) {
        Iterable<StopTime> orderedStopTimes = this.getOrderedStopTimesForTrip(trip_id);
        ArrayList stops = Lists.newArrayList();
        for (StopTime stopTime : orderedStopTimes) {
            stops.add(stopTime.stop_id);
        }
        return stops;
    }

    public void findPatterns() {
        int n = 0;
        HashMultimap tripsForPattern = HashMultimap.create();
        for (String trip_id : this.trips.keySet()) {
            if (++n % 100000 == 0) {
                LOG.info("trip {}", (Object)Util.human(n));
            }
            Trip trip = (Trip)this.trips.get((Object)trip_id);
            TripPatternKey key = new TripPatternKey(trip.route_id);
            StreamSupport.stream(this.getOrderedStopTimesForTrip(trip_id).spliterator(), false).forEach(key::addStopTime);
            tripsForPattern.put((Object)key, (Object)trip_id);
        }
        List<Pattern> patterns = tripsForPattern.asMap().entrySet().stream().map(e -> new Pattern(this, ((TripPatternKey)e.getKey()).stops, new ArrayList<String>((Collection)e.getValue()))).collect(Collectors.toList());
        this.namePatterns(patterns);
        patterns.stream().forEach(p -> {
            this.patterns.put(p.pattern_id, (Pattern)p);
            p.associatedTrips.stream().forEach(t -> this.tripPatternMap.put((String)t, pattern.pattern_id));
        });
        LOG.info("Total patterns: {}", (Object)tripsForPattern.keySet().size());
    }

    private void namePatterns(Collection<Pattern> patterns) {
        String toName;
        String fromName;
        LOG.info("Generating unique names for patterns");
        HashMap<String, PatternNamingInfo> namingInfoForRoute = new HashMap<String, PatternNamingInfo>();
        for (Pattern pattern : patterns) {
            if (pattern.associatedTrips.isEmpty() || pattern.orderedStops.isEmpty()) continue;
            Trip trip = (Trip)this.trips.get((Object)pattern.associatedTrips.get(0));
            String route = trip.route_id;
            if (!namingInfoForRoute.containsKey(route)) {
                namingInfoForRoute.put(route, new PatternNamingInfo());
            }
            PatternNamingInfo namingInfo = (PatternNamingInfo)namingInfoForRoute.get(route);
            if (trip.trip_headsign != null) {
                namingInfo.headsigns.put((Object)trip.trip_headsign, (Object)pattern);
            }
            fromName = this.stops.get((Object)pattern.orderedStops.get((int)0)).stop_name;
            toName = this.stops.get((Object)pattern.orderedStops.get((int)(pattern.orderedStops.size() - 1))).stop_name;
            namingInfo.fromStops.put((Object)fromName, (Object)pattern);
            namingInfo.toStops.put((Object)toName, (Object)pattern);
            pattern.orderedStops.stream().map(this.stops::get).forEach(stop -> {
                if (fromName.equals(stop.stop_name) || toName.equals(stop.stop_name)) {
                    return;
                }
                patternNamingInfo.vias.put((Object)stop.stop_name, (Object)pattern);
            });
            namingInfo.patternsOnRoute.add(pattern);
        }
        for (PatternNamingInfo info : namingInfoForRoute.values()) {
            for (Pattern pattern : info.patternsOnRoute) {
                pattern.name = null;
                String headsign = ((Trip)this.trips.get((Object)pattern.associatedTrips.get((int)0))).trip_headsign;
                fromName = this.stops.get((Object)pattern.orderedStops.get((int)0)).stop_name;
                toName = this.stops.get((Object)pattern.orderedStops.get((int)(pattern.orderedStops.size() - 1))).stop_name;
                HashSet intersection = new HashSet(info.fromStops.get((Object)fromName));
                intersection.retainAll(info.toStops.get((Object)toName));
                if (intersection.size() == 1) {
                    pattern.name = String.format(Locale.US, "from %s to %s", fromName, toName);
                    continue;
                }
                pattern.orderedStops.stream().map(this.stops::get).forEach(stop -> {
                    HashSet viaIntersection = new HashSet(intersection);
                    viaIntersection.retainAll(patternNamingInfo.vias.get((Object)stop.stop_name));
                    if (viaIntersection.size() == 1) {
                        pattern.name = String.format(Locale.US, "from %s to %s via %s", fromName, toName, stop.stop_name);
                    }
                });
                if (pattern.name == null && intersection.size() == 2) {
                    Iterator it = intersection.iterator();
                    Pattern p0 = (Pattern)it.next();
                    Pattern p1 = (Pattern)it.next();
                    if (p0.orderedStops.size() > p1.orderedStops.size()) {
                        p1.name = String.format(Locale.US, "from %s to %s express", fromName, toName);
                        p0.name = String.format(Locale.US, "from %s to %s local", fromName, toName);
                    } else if (p1.orderedStops.size() > p0.orderedStops.size()) {
                        p0.name = String.format(Locale.US, "from %s to %s express", fromName, toName);
                        p1.name = String.format(Locale.US, "from %s to %s local", fromName, toName);
                    }
                }
                if (pattern.name != null) continue;
                pattern.name = String.format(Locale.US, "from %s to %s like trip %s", fromName, toName, pattern.associatedTrips.get(0));
            }
            for (Pattern pattern : info.patternsOnRoute) {
                pattern.name = String.format(Locale.US, "%s stops %s (%s trips)", pattern.orderedStops.size(), pattern.name, pattern.associatedTrips.size());
            }
        }
    }

    public LineString getStraightLineForStops(String trip_id) {
        CoordinateList coordinates = new CoordinateList();
        LineString ls = null;
        Trip trip = (Trip)this.trips.get((Object)trip_id);
        Iterable<StopTime> stopTimes = this.getOrderedStopTimesForTrip(trip.trip_id);
        if (Iterables.size(stopTimes) > 1) {
            for (StopTime stopTime : stopTimes) {
                Stop stop = this.stops.get(stopTime.stop_id);
                Double lat = stop.stop_lat;
                Double lon = stop.stop_lon;
                coordinates.add((Object)new Coordinate(lon.doubleValue(), lat.doubleValue()));
            }
            ls = this.gf.createLineString(coordinates.toCoordinateArray());
        } else {
            ls = null;
        }
        return ls;
    }

    public LineString getTripGeometry(String trip_id) {
        Shape shape;
        CoordinateList coordinates = new CoordinateList();
        LineString ls = null;
        Trip trip = (Trip)this.trips.get((Object)trip_id);
        if (trip.shape_id != null && (shape = this.getShape(trip.shape_id)) != null) {
            ls = shape.geometry;
        }
        if (ls == null) {
            ls = this.getStraightLineForStops(trip_id);
        }
        return ls;
    }

    public double getTripDistance(String trip_id, boolean straightLine) {
        return straightLine ? GeoUtils.getDistance(this.getStraightLineForStops(trip_id)) : GeoUtils.getDistance(this.getTripGeometry(trip_id));
    }

    public double getTripSpeed(String trip_id) {
        return this.getTripSpeed(trip_id, false);
    }

    public double getTripSpeed(String trip_id, boolean straightLine) {
        StopTime firstStopTime = (StopTime)this.stop_times.ceilingEntry((Object)Fun.t2((Object)trip_id, null)).getValue();
        StopTime lastStopTime = (StopTime)this.stop_times.floorEntry((Object)Fun.t2((Object)trip_id, (Object)Fun.HI)).getValue();
        if (!firstStopTime.trip_id.equals(trip_id) || !lastStopTime.trip_id.equals(trip_id)) {
            return Double.NaN;
        }
        double distance = this.getTripDistance(trip_id, straightLine);
        int time = lastStopTime.arrival_time - firstStopTime.departure_time;
        return distance / (double)time;
    }

    public List<StopTime> getStopTimesForStop(String stop_id) {
        SortedSet<Fun.Tuple2<String, Fun.Tuple2>> index = this.stopStopTimeSet.subSet((Fun.Tuple2<String, Fun.Tuple2>)new Fun.Tuple2((Object)stop_id, null), (Fun.Tuple2<String, Fun.Tuple2>)new Fun.Tuple2((Object)stop_id, Fun.HI));
        return index.stream().map(tuple -> (StopTime)this.stop_times.get(tuple.b)).collect(Collectors.toList());
    }

    public List<Trip> getTripsForService(String service_id) {
        SortedSet<Fun.Tuple2<String, String>> index = this.tripsPerService.subSet((Fun.Tuple2<String, String>)new Fun.Tuple2((Object)service_id, null), (Fun.Tuple2<String, String>)new Fun.Tuple2((Object)service_id, Fun.HI));
        return index.stream().map(tuple -> (Trip)this.trips.get(tuple.b)).collect(Collectors.toList());
    }

    public List<Service> getServicesForDate(LocalDate date) {
        String dateString = date.format(dateFormatter);
        SortedSet<Fun.Tuple2<String, String>> index = this.servicesPerDate.subSet((Fun.Tuple2<String, String>)new Fun.Tuple2((Object)dateString, null), (Fun.Tuple2<String, String>)new Fun.Tuple2((Object)dateString, Fun.HI));
        return index.stream().map(tuple -> (Service)this.services.get(tuple.b)).collect(Collectors.toList());
    }

    public List<LocalDate> getDatesOfService() {
        return this.servicesPerDate.stream().map(tuple -> LocalDate.parse((CharSequence)tuple.a, dateFormatter)).collect(Collectors.toList());
    }

    public List<Trip> getDistinctTripsForStop(String stop_id) {
        return this.getStopTimesForStop(stop_id).stream().map(stopTime -> (Trip)this.trips.get((Object)stopTime.trip_id)).distinct().collect(Collectors.toList());
    }

    public ZoneId getAgencyTimeZoneForStop(String stop_id) {
        StopTime stopTime = this.getStopTimesForStop(stop_id).iterator().next();
        Trip trip = (Trip)this.trips.get((Object)stopTime.trip_id);
        Route route = this.routes.get(trip.route_id);
        Agency agency = route.agency_id != null ? this.agency.get(route.agency_id) : this.agency.get(0);
        return ZoneId.of(agency.agency_timezone);
    }

    public Geometry getMergedBuffers() {
        if (this.mergedBuffers == null) {
            ArrayList<Polygon> polygons = new ArrayList<Polygon>();
            for (Stop stop : this.stops.values()) {
                if (this.getStopTimesForStop(stop.stop_id).isEmpty() || stop.stop_lat > -1.0 && stop.stop_lat < 1.0 || stop.stop_lon > -1.0 && stop.stop_lon < 1.0) continue;
                Point stopPoint = this.gf.createPoint(new Coordinate(stop.stop_lon, stop.stop_lat));
                Polygon stopBuffer = (Polygon)stopPoint.buffer(0.01);
                polygons.add(stopBuffer);
            }
            Geometry multiGeometry = this.gf.buildGeometry(polygons);
            this.mergedBuffers = multiGeometry.union();
            if (polygons.size() > 100) {
                this.mergedBuffers = DouglasPeuckerSimplifier.simplify((Geometry)this.mergedBuffers, (double)0.001);
            }
        }
        return this.mergedBuffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Polygon getConvexHull() {
        if (this.convexHull == null) {
            GTFSFeed gTFSFeed = this;
            synchronized (gTFSFeed) {
                List<Coordinate> coordinates = this.stops.values().stream().map(stop -> new Coordinate(stop.stop_lon, stop.stop_lat)).collect(Collectors.toList());
                Coordinate[] coords = coordinates.toArray(new Coordinate[coordinates.size()]);
                ConvexHull convexHull = new ConvexHull(coords, this.gf);
                this.convexHull = (Polygon)convexHull.getConvexHull();
            }
        }
        return this.convexHull;
    }

    public GTFSFeed clone() {
        try {
            return (GTFSFeed)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.db.close();
    }

    public GTFSFeed() {
        this(DBMaker.newTempFileDB().transactionDisable().mmapFileEnable().asyncWriteEnable().deleteFilesAfterClose().compressionEnable().make());
    }

    public GTFSFeed(String dbFile) throws IOException, ExecutionException {
        this(GTFSFeed.constructDB(dbFile));
    }

    private static DB constructDB(String dbFile) {
        try {
            DBMaker dbMaker = DBMaker.newFileDB((File)new File(dbFile));
            DB db = dbMaker.transactionDisable().mmapFileEnable().asyncWriteEnable().compressionEnable().make();
            return db;
        }
        catch (ExecutionError | IOError | Exception e) {
            LOG.error("Could not construct db from file.", e);
            return null;
        }
    }

    private GTFSFeed(DB db) {
        this.db = db;
        this.agency = db.getTreeMap("agency");
        this.feedInfo = db.getTreeMap("feed_info");
        this.routes = db.getTreeMap("routes");
        this.trips = db.getTreeMap("trips");
        this.stop_times = db.getTreeMap("stop_times");
        this.frequencies = db.getTreeSet("frequencies");
        this.transfers = db.getTreeMap("transfers");
        this.stops = db.getTreeMap("stops");
        this.fares = db.getTreeMap("fares");
        this.services = db.getTreeMap("services");
        this.shape_points = db.getTreeMap("shape_points");
        this.feedId = db.getAtomicString("feed_id").get();
        this.checksum = db.getAtomicLong("checksum").get();
        this.patterns = db.createTreeMap("patterns").valueSerializer(Serializer.JAVA).makeOrGet();
        this.tripPatternMap = db.getTreeMap("patternForTrip");
        this.stopCountByStopTime = db.getTreeMap("stopCountByStopTime");
        this.stopStopTimeSet = db.getTreeSet("stopStopTimeSet");
        this.tripsPerService = db.getTreeSet("tripsPerService");
        this.servicesPerDate = db.getTreeSet("servicesPerDate");
        this.errors = db.getTreeSet("errors");
    }

    private static class PatternNamingInfo {
        Multimap<String, Pattern> headsigns = HashMultimap.create();
        Multimap<String, Pattern> fromStops = HashMultimap.create();
        Multimap<String, Pattern> toStops = HashMultimap.create();
        Multimap<String, Pattern> vias = HashMultimap.create();
        List<Pattern> patternsOnRoute = new ArrayList<Pattern>();

        private PatternNamingInfo() {
        }
    }

    public class FirstAndLastStopsDoNotHaveTimes
    extends Exception {
    }
}

