/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.stats.FeedStats;
import com.conveyal.gtfs.util.json.JsonManager;
import com.conveyal.gtfs.validator.model.ValidationResult;
import java.io.File;
import java.util.zip.ZipFile;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GTFSMain {
    private static final Logger LOG = LoggerFactory.getLogger(GTFSMain.class);

    public static void main(String[] args) throws Exception {
        DefaultParser parser = new DefaultParser();
        Options options = GTFSMain.getOptions();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption("help")) {
            GTFSMain.printHelp(options);
            return;
        }
        if (args.length < 1) {
            System.out.println("Please specify a GTFS feed to load.");
            System.exit(1);
        }
        File tempFile = File.createTempFile("gtfs", ".db");
        GTFSFeed feed = new GTFSFeed(tempFile.getAbsolutePath());
        feed.loadFromFile(new ZipFile(args[0]));
        feed.findPatterns();
        if (cmd.hasOption("validate")) {
            feed.validate();
            JsonManager<ValidationResult> json = new JsonManager<ValidationResult>(ValidationResult.class);
            ValidationResult result = new ValidationResult(args[0], feed, new FeedStats(feed));
            File resultFile = args.length >= 2 ? new File(args[1]) : File.createTempFile("result", ".json");
            FileUtils.writeStringToFile((File)resultFile, (String)json.write(result));
            LOG.info("Storing validation result at: {}", (Object)resultFile.getAbsolutePath());
        }
        feed.close();
        LOG.info("reopening feed");
        GTFSFeed reconnected = new GTFSFeed(tempFile.getAbsolutePath());
        LOG.info("Connected to already loaded feed");
        LOG.info("  {} routes", (Object)reconnected.routes.size());
        LOG.info("  {} trips", (Object)reconnected.trips.size());
        LOG.info("  {} stop times", (Object)reconnected.stop_times.size());
        LOG.info("  Feed ID: {}", (Object)reconnected.feedId);
    }

    private static void printHelp(Options options) {
        String HELP = String.join((CharSequence)"\n", "java -jar gtfs-lib-shaded.jar [options] INPUT.zip [result.json]", "Load input GTFS feed into storage-backed MapDB for use in Java-based", "applications. Optionally, write feed to output location. For more, see", "https://github.com/conveyal/gtfs-lib#gtfs-lib", "", "");
        HelpFormatter formatter = new HelpFormatter();
        System.out.println();
        formatter.printHelp(HELP, options);
        System.out.println();
    }

    private static Options getOptions() {
        Options options = new Options();
        Option help = new Option("help", false, "print this message");
        Option validate = new Option("validate", false, "run full validation suite on input GTFS feed (optionally store at [result.json])");
        options.addOption(help);
        options.addOption(validate);
        return options;
    }
}

