/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.model;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.error.DuplicateKeyError;
import com.conveyal.gtfs.model.Entity;
import com.conveyal.gtfs.model.Service;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public class Calendar
extends Entity
implements Serializable {
    private static final long serialVersionUID = 6634236680822635875L;
    public int monday;
    public int tuesday;
    public int wednesday;
    public int thursday;
    public int friday;
    public int saturday;
    public int sunday;
    public int start_date;
    public int end_date;
    public String feed_id;
    public String service_id;

    public static class Writer
    extends Entity.Writer<Calendar> {
        public Writer(GTFSFeed feed) {
            super(feed, "calendar");
        }

        @Override
        protected void writeHeaders() throws IOException {
            this.writer.writeRecord(new String[]{"service_id", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "start_date", "end_date"});
        }

        @Override
        protected void writeOneRow(Calendar c) throws IOException {
            this.writeStringField(c.service_id);
            this.writeIntField(c.monday);
            this.writeIntField(c.tuesday);
            this.writeIntField(c.wednesday);
            this.writeIntField(c.thursday);
            this.writeIntField(c.friday);
            this.writeIntField(c.saturday);
            this.writeIntField(c.sunday);
            this.writeIntField(c.start_date);
            this.writeIntField(c.end_date);
            this.endRecord();
        }

        @Override
        protected Iterator<Calendar> iterator() {
            Iterator calIt = Iterators.transform(this.feed.services.values().iterator(), (Function)new Function<Service, Calendar>(){

                public Calendar apply(Service s) {
                    return s.calendar;
                }
            });
            return Iterators.filter((Iterator)calIt, (Predicate)new Predicate<Calendar>(){

                public boolean apply(Calendar c) {
                    return c != null;
                }
            });
        }
    }

    public static class Loader
    extends Entity.Loader<Calendar> {
        private final Map<String, Service> services;

        public Loader(GTFSFeed feed, Map<String, Service> services) {
            super(feed, "calendar");
            this.services = services;
        }

        @Override
        protected boolean isRequired() {
            return true;
        }

        @Override
        public void loadOneRow() throws IOException {
            String service_id = this.getStringField("service_id", true);
            Service service = this.services.computeIfAbsent(service_id, Service::new);
            if (service.calendar != null) {
                this.feed.errors.add(new DuplicateKeyError(this.tableName, this.row, "service_id"));
            } else {
                Calendar c = new Calendar();
                c.sourceFileLine = this.row + 1L;
                c.service_id = service.service_id;
                c.monday = this.getIntField("monday", true, 0, 1);
                c.tuesday = this.getIntField("tuesday", true, 0, 1);
                c.wednesday = this.getIntField("wednesday", true, 0, 1);
                c.thursday = this.getIntField("thursday", true, 0, 1);
                c.friday = this.getIntField("friday", true, 0, 1);
                c.saturday = this.getIntField("saturday", true, 0, 1);
                c.sunday = this.getIntField("sunday", true, 0, 1);
                c.start_date = this.getIntField("start_date", true, 18500101, 22001231);
                c.end_date = this.getIntField("end_date", true, 18500101, 22001231);
                c.feed = this.feed;
                c.feed_id = this.feed.feedId;
                service.calendar = c;
            }
        }
    }
}

