/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.model;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Trip;
import com.google.common.base.Joiner;
import com.vividsolutions.jts.geom.LineString;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;

public class Pattern
implements Serializable {
    public static final long serialVersionUID = 1L;
    public String pattern_id;
    public int[] segmentIndex;
    public double[] segmentFraction;
    public List<String> orderedStops;
    public List<String> associatedTrips;
    public LineString geometry;
    public String name;
    public String route_id;
    public static Joiner joiner = Joiner.on((String)"-").skipNulls();
    public String feed_id;

    public Pattern(GTFSFeed feed, List<String> orderedStops, List<String> trips) {
        this.feed_id = feed.feedId;
        this.pattern_id = UUID.randomUUID().toString();
        this.orderedStops = orderedStops;
        this.associatedTrips = trips;
        String trip_id = this.associatedTrips.get(0);
        Trip trip = (Trip)feed.trips.get((Object)trip_id);
        this.geometry = feed.getTripGeometry(trip.trip_id);
        this.route_id = trip.route_id;
        this.name = trip.trip_headsign != null ? trip.trip_headsign : (trip.trip_short_name != null ? trip.trip_short_name : (trip.direction_id >= 0 ? String.valueOf(trip.direction_id) : joiner.join(orderedStops)));
    }
}

