/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.model;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Entity;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import org.mapdb.Fun;

public class StopTime
extends Entity
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8883780047901081832L;
    public String trip_id;
    public int arrival_time = Integer.MIN_VALUE;
    public int departure_time = Integer.MIN_VALUE;
    public String stop_id;
    public int stop_sequence;
    public String stop_headsign;
    public int pickup_type;
    public int drop_off_type;
    public double shape_dist_traveled;
    public int timepoint = Integer.MIN_VALUE;

    public StopTime clone() {
        try {
            return (StopTime)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Writer
    extends Entity.Writer<StopTime> {
        public Writer(GTFSFeed feed) {
            super(feed, "stop_times");
        }

        @Override
        protected void writeHeaders() throws IOException {
            this.writer.writeRecord(new String[]{"trip_id", "arrival_time", "departure_time", "stop_id", "stop_sequence", "stop_headsign", "pickup_type", "drop_off_type", "shape_dist_traveled", "timepoint"});
        }

        @Override
        protected void writeOneRow(StopTime st) throws IOException {
            this.writeStringField(st.trip_id);
            this.writeTimeField(st.arrival_time);
            this.writeTimeField(st.departure_time);
            this.writeStringField(st.stop_id);
            this.writeIntField(st.stop_sequence);
            this.writeStringField(st.stop_headsign);
            this.writeIntField(st.pickup_type);
            this.writeIntField(st.drop_off_type);
            this.writeDoubleField(st.shape_dist_traveled);
            this.writeIntField(st.timepoint);
            this.endRecord();
        }

        @Override
        protected Iterator<StopTime> iterator() {
            return this.feed.stop_times.values().iterator();
        }
    }

    public static class Loader
    extends Entity.Loader<StopTime> {
        public Loader(GTFSFeed feed) {
            super(feed, "stop_times");
        }

        @Override
        protected boolean isRequired() {
            return true;
        }

        @Override
        public void loadOneRow() throws IOException {
            StopTime st = new StopTime();
            st.sourceFileLine = this.row + 1L;
            st.trip_id = this.getStringField("trip_id", true);
            st.arrival_time = this.getTimeField("arrival_time", false);
            st.departure_time = this.getTimeField("departure_time", false);
            st.stop_id = this.getStringField("stop_id", true);
            st.stop_sequence = this.getIntField("stop_sequence", true, 0, Integer.MAX_VALUE);
            st.stop_headsign = this.getStringField("stop_headsign", false);
            st.pickup_type = this.getIntField("pickup_type", false, 0, 3);
            st.drop_off_type = this.getIntField("drop_off_type", false, 0, 3);
            st.shape_dist_traveled = this.getDoubleField("shape_dist_traveled", false, 0.0, Double.MAX_VALUE);
            st.timepoint = this.getIntField("timepoint", false, 0, 1, Integer.MIN_VALUE);
            st.feed = null;
            this.feed.stop_times.put((Object)new Fun.Tuple2((Object)st.trip_id, (Object)st.stop_sequence), (Object)st);
            this.getRefField("trip_id", true, this.feed.trips);
            this.getRefField("stop_id", true, this.feed.stops);
        }
    }
}

