/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.stats;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Route;
import com.conveyal.gtfs.model.Service;
import com.conveyal.gtfs.model.Stop;
import com.conveyal.gtfs.model.StopTime;
import com.conveyal.gtfs.model.Trip;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class AgencyStats {
    private GTFSFeed feed = null;

    public static Integer getRouteCount(GTFSFeed feed, String agencyId) {
        int count = 0;
        for (Route route : feed.routes.values()) {
            if (!agencyId.equals(route.agency_id)) continue;
            ++count;
        }
        return count;
    }

    public static Integer getTripCount(GTFSFeed feed, String agencyId) {
        int count = 0;
        for (Trip trip : feed.trips.values()) {
            Route route = feed.routes.get(trip.route_id);
            if (!agencyId.equals(route.agency_id)) continue;
            ++count;
        }
        return count;
    }

    public static Integer getStopCount(GTFSFeed feed, String agencyId) {
        int count = 0;
        for (Stop stop : feed.stops.values()) {
            ++count;
        }
        return count;
    }

    public static Integer getStopTimesCount(GTFSFeed feed, String agencyId) {
        int count = 0;
        for (StopTime stopTime : feed.stop_times.values()) {
            Trip trip = (Trip)feed.trips.get((Object)stopTime.trip_id);
            Route route = feed.routes.get(trip.route_id);
            if (!agencyId.equals(route.agency_id)) continue;
            ++count;
        }
        return count;
    }

    public static LocalDate getCalendarServiceRangeStart(GTFSFeed feed, String agencyId) {
        int startDate = 0;
        for (Service service : feed.services.values()) {
            if (startDate != 0 && service.calendar.start_date >= startDate) continue;
            startDate = service.calendar.start_date;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        return LocalDate.parse(String.valueOf(startDate), formatter);
    }

    public static LocalDate getCalendarServiceRangeEnd(GTFSFeed feed, String agencyId) {
        int endDate = 0;
        for (Service service : feed.services.values()) {
            if (endDate != 0 && service.calendar.end_date <= endDate) continue;
            endDate = service.calendar.end_date;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        return LocalDate.parse(String.valueOf(endDate), formatter);
    }

    public static LocalDate getCalendarDateStart(GTFSFeed feed, String agencyId) {
        LocalDate startDate = null;
        for (Service service : feed.services.values()) {
            for (LocalDate date : service.calendar_dates.keySet()) {
                if (startDate != null && !date.isBefore(startDate)) continue;
                startDate = date;
            }
        }
        return startDate;
    }

    public static LocalDate getCalendarDateEnd(GTFSFeed feed, String agencyId) {
        LocalDate endDate = null;
        for (Service service : feed.services.values()) {
            for (LocalDate date : service.calendar_dates.keySet()) {
                if (endDate != null && !date.isAfter(endDate)) continue;
                endDate = date;
            }
        }
        return endDate;
    }
}

