/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.stats;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Agency;
import com.conveyal.gtfs.model.Service;
import com.conveyal.gtfs.model.Stop;
import com.conveyal.gtfs.model.Trip;
import com.conveyal.gtfs.stats.AgencyStats;
import com.conveyal.gtfs.stats.PatternStats;
import com.conveyal.gtfs.stats.RouteStats;
import com.conveyal.gtfs.stats.StopStats;
import com.conveyal.gtfs.stats.model.AgencyStatistic;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class FeedStats {
    private GTFSFeed feed = null;
    public String feed_id = null;
    public PatternStats pattern = null;
    public StopStats stop = null;
    public RouteStats route = null;

    public FeedStats(GTFSFeed f) {
        this.feed = f;
        this.feed_id = f.feedId;
        this.pattern = new PatternStats(this.feed, this);
        this.stop = new StopStats(this.feed, this);
        this.route = new RouteStats(this.feed, this);
    }

    public Integer getAgencyCount() {
        return this.feed.agency.size();
    }

    public Integer getRouteCount() {
        return this.feed.routes.size();
    }

    public Integer getTripCount() {
        return this.feed.trips.size();
    }

    public Integer getTripCount(LocalDate date) {
        return this.getTripsForDate(date).size();
    }

    public Integer getStopCount() {
        return this.feed.stops.size();
    }

    public Integer getStopTimesCount() {
        return this.feed.stop_times.size();
    }

    public LocalDate getCalendarServiceRangeStart() {
        int startDate = 0;
        for (Service service : this.feed.services.values()) {
            if (service.calendar == null || startDate != 0 && service.calendar.start_date >= startDate) continue;
            startDate = service.calendar.start_date;
        }
        if (startDate == 0) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        return LocalDate.parse(String.valueOf(startDate), formatter);
    }

    public LocalDate getCalendarServiceRangeEnd() {
        int endDate = 0;
        for (Service service : this.feed.services.values()) {
            if (service.calendar == null || endDate != 0 && service.calendar.end_date <= endDate) continue;
            endDate = service.calendar.end_date;
        }
        if (endDate == 0) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        return LocalDate.parse(String.valueOf(endDate), formatter);
    }

    public LocalDate getCalendarDateStart() {
        LocalDate startDate = null;
        for (Service service : this.feed.services.values()) {
            for (LocalDate date : service.calendar_dates.keySet()) {
                if (startDate != null && !date.isBefore(startDate)) continue;
                startDate = date;
            }
        }
        return startDate;
    }

    public LocalDate getCalendarDateEnd() {
        LocalDate endDate = null;
        for (Service service : this.feed.services.values()) {
            for (LocalDate date : service.calendar_dates.keySet()) {
                if (endDate != null && !date.isAfter(endDate)) continue;
                endDate = date;
            }
        }
        return endDate;
    }

    public Map<LocalDate, Integer> getTripCountPerDateOfService() {
        Map<LocalDate, List<Trip>> tripsPerDate = this.getTripsPerDateOfService();
        HashMap<LocalDate, Integer> tripCountPerDate = new HashMap<LocalDate, Integer>();
        for (Map.Entry<LocalDate, List<Trip>> entry : tripsPerDate.entrySet()) {
            LocalDate date = entry.getKey();
            Integer count = entry.getValue().size();
            tripCountPerDate.put(date, count);
        }
        return tripCountPerDate;
    }

    public LocalDate getStartDate() {
        LocalDate startDate = null;
        if (this.feed.hasFeedInfo()) {
            startDate = this.feed.getFeedInfo().feed_start_date;
        }
        if (startDate == null) {
            startDate = this.getCalendarServiceRangeStart();
        }
        if (startDate == null) {
            startDate = this.getCalendarDateStart();
        }
        return startDate;
    }

    public LocalDate getEndDate() {
        LocalDate endDate = null;
        if (this.feed.hasFeedInfo()) {
            endDate = this.feed.getFeedInfo().feed_end_date;
        }
        if (endDate == null) {
            endDate = this.getCalendarServiceRangeEnd();
        }
        if (endDate == null) {
            endDate = this.getCalendarDateEnd();
        }
        return endDate;
    }

    public LocalTime getStartTime(LocalDate date) {
        return this.pattern.getStartTimeForTrips(this.getTripsForDate(date));
    }

    public LocalTime getEndTime(LocalDate date) {
        return this.pattern.getEndTimeForTrips(this.getTripsForDate(date));
    }

    public long getTotalRevenueTimeForDate(LocalDate date) {
        return this.pattern.getTotalRevenueTimeForTrips(this.getTripsForDate(date));
    }

    public long getAverageDailyRevenueTime(int dow) {
        DayOfWeek dayOfWeek = DayOfWeek.of(dow);
        List<LocalDate> dates = this.feed.getDatesOfService().stream().filter(date -> date.getDayOfWeek().equals(dayOfWeek)).collect(Collectors.toList());
        return this.getRevenueTimeForDates(dates) / (long)dates.size();
    }

    public long getAverageWeekdayRevenueTime() {
        List<LocalDate> dates = this.feed.getDatesOfService().stream().filter(date -> {
            int dow = date.getDayOfWeek().getValue();
            boolean isWeekday = dow >= DayOfWeek.MONDAY.getValue() && dow <= DayOfWeek.FRIDAY.getValue();
            return isWeekday;
        }).collect(Collectors.toList());
        return this.getRevenueTimeForDates(dates) / (long)dates.size();
    }

    public long getRevenueTimeForDates(List<LocalDate> dates) {
        HashMap timePerService = new HashMap();
        dates.stream().map(date -> this.feed.getServicesForDate((LocalDate)date)).flatMap(Collection::stream).collect(Collectors.toSet()).stream().forEach(s -> {
            List<Trip> trips = this.feed.getTripsForService(s.service_id);
            long time = this.pattern.getTotalRevenueTimeForTrips(trips);
            timePerService.put(s.service_id, time);
        });
        long total = dates.stream().map(date -> this.feed.getServicesForDate((LocalDate)date).stream().map(s -> (Long)timePerService.get(s.service_id)).mapToLong(time -> time).sum()).mapToLong(time -> time).sum();
        return total;
    }

    public long getTotalRevenueTime() {
        return this.getRevenueTimeForDates(this.feed.getDatesOfService());
    }

    public double getTotalDistanceForTrips(LocalDate date) {
        return this.pattern.getTotalDistanceForTrips(this.getTripsForDate(date));
    }

    public int getDailyAverageHeadway(LocalDate date, LocalTime from, LocalTime to) {
        OptionalDouble avg = this.feed.stops.values().stream().map(s -> this.stop.getAverageHeadwayForStop(s.stop_id, date, from, to)).mapToDouble(headway -> headway.intValue()).average();
        return (int)avg.getAsDouble();
    }

    public double getAverageTripSpeed(LocalDate date, LocalTime from, LocalTime to) {
        List<Trip> trips = this.getTripsForDate(date);
        return this.pattern.getAverageSpeedForTrips(trips, from, to);
    }

    public Map<LocalDate, List<Trip>> getTripsPerDateOfService() {
        HashMap<LocalDate, List<Trip>> tripsPerDate = new HashMap<LocalDate, List<Trip>>();
        HashMap tripsPerService = new HashMap();
        LocalDate startDate = this.getStartDate();
        LocalDate endDate = this.getEndDate();
        if (startDate == null || endDate == null) {
            return tripsPerDate;
        }
        int allDates = (int)ChronoUnit.DAYS.between(startDate, endDate.plus(1L, ChronoUnit.DAYS));
        List dates = IntStream.range(0, allDates).mapToObj(offset -> startDate.plusDays(offset)).collect(Collectors.toList());
        dates.stream().map(date -> this.feed.getServicesForDate((LocalDate)date)).flatMap(Collection::stream).collect(Collectors.toSet()).stream().forEach(s -> {
            List<Trip> trips = this.feed.getTripsForService(s.service_id);
            tripsPerService.put(s.service_id, trips);
        });
        dates.stream().forEach(date -> {
            List trips = this.feed.getServicesForDate((LocalDate)date).stream().map(s -> (List)tripsPerService.get(s.service_id)).flatMap(Collection::stream).collect(Collectors.toList());
            tripsPerDate.put((LocalDate)date, trips);
        });
        return tripsPerDate;
    }

    public List<Trip> getTripsForDate(LocalDate date) {
        return this.feed.getServicesForDate(date).stream().map(s -> this.feed.getTripsForService(s.service_id)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Collection<Agency> getAllAgencies() {
        return this.feed.agency.values();
    }

    public Rectangle2D getBounds() {
        Rectangle2D ret = null;
        for (Stop stop : this.feed.stops.values()) {
            if (!this.feed.stopCountByStopTime.containsKey(stop.stop_id)) continue;
            if (ret == null) {
                ret = new Rectangle2D.Double(stop.stop_lon, stop.stop_lat, 0.0, 0.0);
                continue;
            }
            ret.add(new Point2D.Double(stop.stop_lon, stop.stop_lat));
        }
        return ret;
    }

    public AgencyStatistic getStatistic(String agencyId) {
        AgencyStatistic gs = new AgencyStatistic();
        gs.setAgencyId(agencyId);
        gs.setRouteCount(AgencyStats.getRouteCount(this.feed, agencyId));
        gs.setTripCount(AgencyStats.getTripCount(this.feed, agencyId));
        gs.setStopCount(AgencyStats.getStopCount(this.feed, agencyId));
        gs.setStopTimeCount(AgencyStats.getStopTimesCount(this.feed, agencyId));
        gs.setCalendarStartDate(AgencyStats.getCalendarDateStart(this.feed, agencyId));
        gs.setCalendarEndDate(AgencyStats.getCalendarDateEnd(this.feed, agencyId));
        gs.setCalendarServiceStart(AgencyStats.getCalendarServiceRangeStart(this.feed, agencyId));
        gs.setCalendarServiceEnd(AgencyStats.getCalendarServiceRangeEnd(this.feed, agencyId));
        gs.setBounds(this.getBounds());
        return gs;
    }

    public String getStatisticAsCSV(String agencyId) {
        AgencyStatistic s = this.getStatistic(agencyId);
        return FeedStats.formatStatisticAsCSV(s);
    }

    public static String formatStatisticAsCSV(AgencyStatistic s) {
        StringBuffer buff = new StringBuffer();
        buff.append(s.getAgencyId());
        buff.append(",");
        buff.append(s.getRouteCount());
        buff.append(",");
        buff.append(s.getTripCount());
        buff.append(",");
        buff.append(s.getStopCount());
        buff.append(",");
        buff.append(s.getStopTimeCount());
        buff.append(",");
        buff.append(s.getCalendarServiceStart());
        buff.append(",");
        buff.append(s.getCalendarServiceEnd());
        buff.append(",");
        buff.append(s.getCalendarStartDate());
        buff.append(",");
        buff.append(s.getCalendarEndDate());
        return buff.toString();
    }

    public long getFrequencyCount() {
        return this.feed.frequencies.size();
    }

    public long getShapePointCount() {
        return this.feed.shape_points.size();
    }

    public long getFareAttributeCount() {
        return this.feed.fares.size();
    }

    public long getFareRulesCount() {
        return this.feed.fares.values().stream().mapToInt(fare -> fare.fare_rules.size()).sum();
    }

    public long getServiceCount() {
        return this.feed.services.size();
    }

    public List<LocalDate> getDatesOfService() {
        return this.feed.getDatesOfService();
    }

    public Geometry getMergedBuffers() {
        return this.feed.getMergedBuffers();
    }
}

