/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.stats;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Pattern;
import com.conveyal.gtfs.model.StopTime;
import com.conveyal.gtfs.model.Trip;
import com.conveyal.gtfs.stats.FeedStats;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collection;
import java.util.List;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.mapdb.Fun;

public class PatternStats {
    private GTFSFeed feed = null;
    private FeedStats stats = null;

    public PatternStats(GTFSFeed f, FeedStats fs) {
        this.feed = f;
        this.stats = fs;
    }

    public double getPatternSpeed(String pattern_id, LocalDate date, LocalTime from, LocalTime to) {
        List<Trip> trips = this.getTripsForDate(pattern_id, date);
        return this.getAverageSpeedForTrips(trips, from, to);
    }

    public double getAverageSpeedForTrips(Collection<Trip> trips, LocalTime from, LocalTime to) {
        TDoubleArrayList speeds = new TDoubleArrayList();
        for (Trip trip : trips) {
            double speed;
            StopTime firstStopTime = (StopTime)this.feed.stop_times.ceilingEntry((Object)Fun.t2((Object)trip.trip_id, null)).getValue();
            LocalTime tripBeginTime = LocalTime.ofSecondOfDay(firstStopTime.departure_time % 86399);
            if (tripBeginTime.isAfter(to) || tripBeginTime.isBefore(from) || Double.isNaN(speed = this.feed.getTripSpeed(trip.trip_id, true))) continue;
            speeds.add(speed);
        }
        if (speeds.isEmpty()) {
            return -1.0;
        }
        return speeds.sum() / (double)speeds.size();
    }

    public LocalTime getStartTimeForTrips(Collection<Trip> trips) {
        int earliestDeparture = Integer.MAX_VALUE;
        for (Trip trip : trips) {
            StopTime st = this.feed.getOrderedStopTimesForTrip(trip.trip_id).iterator().next();
            int dep = st.departure_time;
            if (dep > 86399) {
                dep %= 86399;
            }
            if (dep > earliestDeparture) continue;
            earliestDeparture = dep;
        }
        return LocalTime.ofSecondOfDay(earliestDeparture);
    }

    public LocalTime getEndTimeForTrips(Collection<Trip> trips) {
        int latestArrival = Integer.MIN_VALUE;
        for (Trip trip : trips) {
            StopTime st = this.feed.getOrderedStopTimesForTrip(trip.trip_id).iterator().next();
            if (st.arrival_time < latestArrival) continue;
            latestArrival = st.arrival_time;
        }
        return LocalTime.ofSecondOfDay(latestArrival % 86399);
    }

    public long getTotalRevenueTimeForTrips(Collection<Trip> trips) {
        TIntArrayList times = new TIntArrayList();
        for (Trip trip : trips) {
            Spliterator<StopTime> stopTimes = this.feed.getOrderedStopTimesForTrip(trip.trip_id).spliterator();
            StopTime first = StreamSupport.stream(stopTimes, false).findFirst().orElse(null);
            StopTime last = StreamSupport.stream(stopTimes, false).reduce((a, b) -> b).orElse(null);
            if (last == null || first == null) continue;
            int time = last.arrival_time - first.departure_time;
            times.add(time);
        }
        return times.sum();
    }

    public double getTotalDistanceForTrips(Collection<Trip> trips) {
        TDoubleArrayList distances = new TDoubleArrayList();
        for (Trip trip : trips) {
            distances.add(this.feed.getTripDistance(trip.trip_id, false));
        }
        return distances.sum();
    }

    public double getPatternDistance(String pattern_id) {
        Pattern pattern = this.feed.patterns.get(pattern_id);
        return this.feed.getTripDistance(pattern.associatedTrips.iterator().next(), false);
    }

    public double getAverageStopSpacing(String pattern_id) {
        Pattern pattern = this.feed.patterns.get(pattern_id);
        return this.getPatternDistance(pattern_id) / (double)pattern.orderedStops.size();
    }

    public int getHeadwayForPattern(String pattern_id, LocalDate date, LocalTime from, LocalTime to) {
        List<Trip> tripsForPattern = this.getTripsForDate(pattern_id, date);
        String commonStop = this.stats.route.getCommonStopForTrips(tripsForPattern);
        if (commonStop == null) {
            return -1;
        }
        return this.stats.stop.getStopHeadwayForTrips(commonStop, tripsForPattern, from, to);
    }

    public long getTripCountForDate(String pattern_id, LocalDate date) {
        return this.getTripsForDate(pattern_id, date).size();
    }

    public List<Trip> getTripsForDate(String pattern_id, LocalDate date) {
        Pattern pattern = this.feed.patterns.get(pattern_id);
        if (pattern == null) {
            return null;
        }
        return this.stats.getTripsForDate(date).stream().filter(trip -> pattern.associatedTrips.contains(trip.trip_id)).collect(Collectors.toList());
    }
}

