/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.stats;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Route;
import com.conveyal.gtfs.model.Trip;
import com.conveyal.gtfs.stats.FeedStats;
import com.conveyal.gtfs.stats.PatternStats;
import com.conveyal.gtfs.stats.StopStats;
import com.conveyal.gtfs.stats.model.RouteStatistic;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RouteStats {
    private GTFSFeed feed = null;
    private FeedStats stats = null;
    private PatternStats patternStats = null;
    private StopStats stopStats = null;

    public RouteStats(GTFSFeed f, FeedStats fs) {
        this.feed = f;
        this.stats = fs;
        this.patternStats = this.stats.pattern;
        this.stopStats = this.stats.stop;
    }

    public List<RouteStatistic> getStatisticForAll(LocalDate date, LocalTime from, LocalTime to) {
        ArrayList<RouteStatistic> stats = new ArrayList<RouteStatistic>();
        for (String id : this.feed.routes.keySet()) {
            stats.add(this.getStatisticForRoute(id, date, from, to));
        }
        return stats;
    }

    public String getStatisticForAllAsCsv(LocalDate date, LocalTime from, LocalTime to) {
        List<RouteStatistic> stats = this.getStatisticForAll(date, from, to);
        StringBuffer buffer = new StringBuffer();
        buffer.append(RouteStatistic.getHeaderAsCsv());
        for (RouteStatistic rs : stats) {
            buffer.append(System.getProperty("line.separator"));
            buffer.append(rs.asCsv());
        }
        return buffer.toString();
    }

    public String getRouteName(String route_id) {
        Route route = this.feed.routes.get(route_id);
        return route != null ? route.route_short_name + " - " + route.route_long_name : null;
    }

    public double getSpeedForRouteDirection(String route_id, int direction_id, LocalDate date, LocalTime from, LocalTime to) {
        List<Trip> tripsForRouteDirection = this.getTripsForDate(route_id, date).stream().filter(t -> t.direction_id == direction_id).collect(Collectors.toList());
        return this.patternStats.getAverageSpeedForTrips(tripsForRouteDirection, from, to);
    }

    public int getHeadwayForRouteDirection(String route_id, int direction_id, LocalDate date, LocalTime from, LocalTime to) {
        List<Trip> tripsForRouteDirection = this.getTripsForDate(route_id, date).stream().filter(t -> t.direction_id == direction_id).collect(Collectors.toList());
        String commonStop = this.getCommonStopForTrips(tripsForRouteDirection);
        if (commonStop == null) {
            return -1;
        }
        return this.stats.stop.getStopHeadwayForTrips(commonStop, tripsForRouteDirection, from, to);
    }

    public String getCommonStopForTrips(List<Trip> trips) {
        HashSet<String> commonStops = null;
        for (Trip trip : trips) {
            List<String> stops = this.feed.getOrderedStopListForTrip(trip.trip_id);
            if (commonStops == null) {
                commonStops = new HashSet<String>(stops);
                continue;
            }
            commonStops.retainAll(stops);
        }
        if (commonStops == null || commonStops.isEmpty()) {
            return null;
        }
        String commonStop = (String)commonStops.iterator().next();
        return commonStop;
    }

    public LocalTime getStartTimeForRouteDirection(String route_id, int direction_id, LocalDate date) {
        List<Trip> tripsForRouteDirection = this.getTripsForDate(route_id, date).stream().filter(t -> t.direction_id == direction_id).collect(Collectors.toList());
        return this.patternStats.getStartTimeForTrips(tripsForRouteDirection);
    }

    public LocalTime getEndTimeForRouteDirection(String route_id, int direction_id, LocalDate date) {
        List<Trip> tripsForRouteDirection = this.getTripsForDate(route_id, date).stream().filter(t -> t.direction_id == direction_id).collect(Collectors.toList());
        return this.patternStats.getEndTimeForTrips(tripsForRouteDirection);
    }

    public Map<LocalDate, Integer> getTripCountPerDateOfService(String route_id) {
        Route route = this.feed.routes.get(route_id);
        if (route == null) {
            return null;
        }
        Map<LocalDate, List<Trip>> tripsPerDate = this.getTripsPerDateOfService(route_id);
        HashMap<LocalDate, Integer> tripCountPerDate = new HashMap<LocalDate, Integer>();
        for (Map.Entry<LocalDate, List<Trip>> entry : tripsPerDate.entrySet()) {
            LocalDate date = entry.getKey();
            Integer count = entry.getValue().size();
            tripCountPerDate.put(date, count);
        }
        return tripCountPerDate;
    }

    public Map<LocalDate, List<Trip>> getTripsPerDateOfService(String route_id) {
        Map<LocalDate, List<Trip>> tripsPerDate = this.stats.getTripsPerDateOfService();
        for (Map.Entry<LocalDate, List<Trip>> e : tripsPerDate.entrySet()) {
            LocalDate date = e.getKey();
            List trips = e.getValue().stream().filter(t -> t.route_id.equals(route_id)).collect(Collectors.toList());
            tripsPerDate.put(date, trips);
        }
        return tripsPerDate;
    }

    public List<Trip> getTripsForDate(String route_id, LocalDate date) {
        Route route = this.feed.routes.get(route_id);
        if (route == null) {
            return null;
        }
        List<Trip> trips = this.stats.getTripsForDate(date).stream().filter(trip -> route_id.equals(trip.route_id)).collect(Collectors.toList());
        return trips;
    }

    public long getTripCountForDate(String route_id, LocalDate date) {
        return this.getTripsForDate(route_id, date).size();
    }

    public double getAverageStopSpacing(String route_id) {
        return this.feed.patterns.values().stream().filter(p -> p.route_id.equals(route_id)).map(p -> this.stats.pattern.getAverageStopSpacing(p.pattern_id)).mapToDouble(headway -> headway).average().getAsDouble();
    }

    public RouteStatistic getStatisticForRoute(String route_id, LocalDate date, LocalTime from, LocalTime to) {
        RouteStatistic rs = new RouteStatistic(this, route_id, date, from, to);
        return rs;
    }

    public String getKCMetroStatistics() {
        for (Route route : this.feed.routes.values()) {
        }
        return null;
    }

    public String getStatisticsAsCsv() {
        return null;
    }
}

