/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.stats;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Route;
import com.conveyal.gtfs.model.Service;
import com.conveyal.gtfs.model.StopTime;
import com.conveyal.gtfs.model.Trip;
import com.conveyal.gtfs.stats.FeedStats;
import com.conveyal.gtfs.stats.RouteStats;
import com.conveyal.gtfs.stats.model.TransferPerformanceSummary;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mapdb.Fun;

public class StopStats {
    private GTFSFeed feed = null;
    private FeedStats stats = null;
    private RouteStats routeStats = null;

    public StopStats(GTFSFeed f, FeedStats fs) {
        this.feed = f;
        this.stats = fs;
        this.routeStats = this.stats.route;
    }

    public List<Route> getRoutes(String stop_id) {
        return this.feed.patterns.values().stream().filter(p -> p.orderedStops.contains(stop_id)).distinct().map(p -> this.feed.routes.get(p.route_id)).collect(Collectors.toList());
    }

    public int getRouteCount(String stop_id) {
        return this.getRoutes(stop_id).size();
    }

    public int getTripCountForDate(String stop_id, LocalDate date) {
        return this.getTripsForDate(stop_id, date).size();
    }

    public List<Trip> getTripsForDate(String stop_id, LocalDate date) {
        List tripIds = this.stats.getTripsForDate(date).stream().map(trip -> trip.trip_id).collect(Collectors.toList());
        return this.feed.getDistinctTripsForStop(stop_id).stream().filter(t -> tripIds.contains(t.trip_id)).collect(Collectors.toList());
    }

    public int getAverageHeadwayForStop(String stop_id, LocalDate date, LocalTime from, LocalTime to) {
        List<Trip> tripsForStop = this.getTripsForDate(stop_id, date);
        return this.getStopHeadwayForTrips(stop_id, tripsForStop, from, to);
    }

    public Map<String, Integer> getRouteHeadwaysForStop(String stop_id, LocalDate date, LocalTime from, LocalTime to) {
        HashMap<String, Integer> routeHeadwayMap = new HashMap<String, Integer>();
        List routes = this.feed.patterns.values().stream().filter(p -> p.orderedStops.contains(stop_id)).map(p -> this.feed.routes.get(p.route_id)).collect(Collectors.toList());
        for (Route route : routes) {
            routeHeadwayMap.put(route.route_id, this.getHeadwayForStopByRoute(stop_id, route.route_id, date, from, to));
        }
        return routeHeadwayMap;
    }

    public int getStopHeadwayForTrips(String stop_id, List<Trip> trips, LocalTime from, LocalTime to) {
        TIntArrayList timesAtStop = new TIntArrayList();
        Set tripIds = trips.stream().map(t -> t.trip_id).collect(Collectors.toSet());
        List stopTimes = this.feed.getStopTimesForStop(stop_id).stream().filter(st -> tripIds.contains(st.trip_id)).collect(Collectors.toList());
        for (StopTime st2 : stopTimes) {
            LocalTime timeAtStop;
            if (st2.departure_time > 86399 || st2.departure_time < 0 || (timeAtStop = LocalTime.ofSecondOfDay(st2.departure_time)).isAfter(to) || timeAtStop.isBefore(from)) continue;
            timesAtStop.add(st2.departure_time);
        }
        timesAtStop.sort();
        TIntArrayList deltas = new TIntArrayList();
        for (int i = 0; i < timesAtStop.size() - 1; ++i) {
            int delta = timesAtStop.get(i + 1) - timesAtStop.get(i);
            if (delta <= 60) continue;
            deltas.add(delta);
        }
        if (deltas.isEmpty()) {
            return -1;
        }
        return deltas.sum() / deltas.size();
    }

    public int getHeadwayForStopByRoute(String stop_id, String route_id, LocalDate date, LocalTime from, LocalTime to) {
        List<Trip> tripsForStop = this.feed.getDistinctTripsForStop(stop_id).stream().filter(trip -> ((Trip)this.feed.trips.get((Object)trip.trip_id)).route_id.equals(route_id)).filter(trip -> ((Service)this.feed.services.get((Object)trip.service_id)).activeOn(date)).collect(Collectors.toList());
        return this.getStopHeadwayForTrips(stop_id, tripsForStop, from, to);
    }

    public List<TransferPerformanceSummary> getTransferPerformance(String stop_id, LocalDate date) {
        List<StopTime> stopTimes = this.feed.getStopTimesForStop(stop_id);
        HashMap routeStopTimeMap = new HashMap();
        ArrayList<TransferPerformanceSummary> transferPerformanceMap = new ArrayList<TransferPerformanceSummary>();
        stopTimes.stream().forEach(st -> {
            Trip trip = (Trip)this.feed.trips.get((Object)st.trip_id);
            Service service = (Service)this.feed.services.get((Object)trip.service_id);
            if (service != null && service.activeOn(date)) {
                Route route = this.feed.routes.get(trip.route_id);
                ArrayList<StopTime> times = new ArrayList<StopTime>();
                if (routeStopTimeMap.containsKey(route.route_id)) {
                    times.addAll((Collection)routeStopTimeMap.get(route.route_id));
                }
                times.add((StopTime)st);
                routeStopTimeMap.put(route.route_id, times);
            }
        });
        HashMap<Fun.Tuple2, TIntArrayList> waitTimesByRoute = new HashMap<Fun.Tuple2, TIntArrayList>();
        HashMap missedTransfers = new HashMap();
        for (Map.Entry entry : routeStopTimeMap.entrySet()) {
            int MISSED_TRANSFER_THRESHOLD = 600;
            List currentTimes = (List)entry.getValue();
            String currentRoute = (String)entry.getKey();
            for (StopTime currentTime : currentTimes) {
                if (currentTime.arrival_time <= 0) continue;
                for (Map.Entry entry2 : routeStopTimeMap.entrySet()) {
                    List compareTimes = (List)entry2.getValue();
                    String compareRoute = (String)entry2.getKey();
                    Fun.Tuple2 routeKey = new Fun.Tuple2((Object)currentRoute, (Object)compareRoute);
                    if (compareRoute.equals(currentRoute)) continue;
                    if (!waitTimesByRoute.containsKey(routeKey)) {
                        waitTimesByRoute.put(routeKey, new TIntArrayList());
                    }
                    int shortestWait = Integer.MAX_VALUE;
                    for (StopTime compareTime : compareTimes) {
                        if (compareTime.departure_time <= 0) continue;
                        int waitTime = compareTime.departure_time - currentTime.arrival_time;
                        if (waitTime >= 0 && waitTime < shortestWait) {
                            shortestWait = waitTime;
                            continue;
                        }
                        if (waitTime >= 0 || waitTime * -1 > 600) continue;
                        Fun.Tuple2 missedTransfer = new Fun.Tuple2((Object)compareTime, (Object)currentTime);
                        if (!missedTransfers.containsKey(routeKey)) {
                            missedTransfers.put(routeKey, new HashSet());
                        }
                        ((Set)missedTransfers.get(routeKey)).add(missedTransfer);
                    }
                    if (shortestWait >= Integer.MAX_VALUE) continue;
                    ((TIntList)waitTimesByRoute.get(routeKey)).add(shortestWait);
                }
            }
        }
        for (Map.Entry entry : waitTimesByRoute.entrySet()) {
            Fun.Tuple2 routeKey = (Fun.Tuple2)entry.getKey();
            TIntList waitTimes = (TIntList)entry.getValue();
            if (waitTimes.isEmpty()) continue;
            int min = waitTimes.min();
            int max = waitTimes.max();
            waitTimes.sort();
            int median = waitTimes.get(waitTimes.size() / 2);
            TransferPerformanceSummary routeTransferPerformance = new TransferPerformanceSummary((String)routeKey.a, (String)routeKey.b, min, max, median, (Set)missedTransfers.get(routeKey));
            transferPerformanceMap.add(routeTransferPerformance);
        }
        return transferPerformanceMap;
    }
}

