/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.stats.model;

import com.conveyal.gtfs.stats.FeedStats;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;

public class FeedStatistic
implements Serializable {
    public String feed_id;
    public int headway;
    public Double avgSpeed;
    public long revenueTime;
    public LocalDate startDate;
    public LocalDate endDate;
    public long agencyCount;
    public long routeCount;
    public long stopCount;
    public long tripCount;
    public long frequencyCount;
    public long stopTimeCount;
    public long shapePointCount;
    public long fareAttributeCount;
    public long fareRuleCount;
    public long serviceCount;
    public List<LocalDate> datesOfService;
    public Rectangle2D bounds;
    public Geometry mergedBuffers;

    public FeedStatistic(FeedStats stats, LocalDate date, LocalTime from, LocalTime to) {
        this.feed_id = stats.feed_id;
        this.headway = stats.getDailyAverageHeadway(date, from, to);
        this.avgSpeed = stats.getAverageTripSpeed(date, from, to);
        this.tripCount = stats.getTripCount(date).intValue();
        this.revenueTime = stats.getTotalRevenueTimeForDate(date);
    }

    public FeedStatistic(FeedStats stats) {
        this.feed_id = stats.feed_id;
        this.startDate = stats.getStartDate();
        this.endDate = stats.getEndDate();
        this.agencyCount = stats.getAgencyCount().intValue();
        this.routeCount = stats.getRouteCount().intValue();
        this.stopCount = stats.getStopCount().intValue();
        this.tripCount = stats.getTripCount().intValue();
        this.frequencyCount = stats.getFrequencyCount();
        this.stopTimeCount = stats.getStopTimesCount().intValue();
        this.shapePointCount = stats.getShapePointCount();
        this.fareAttributeCount = stats.getFareAttributeCount();
        this.fareRuleCount = stats.getFareRulesCount();
        this.serviceCount = stats.getServiceCount();
        this.datesOfService = stats.getDatesOfService();
        this.bounds = stats.getBounds();
        this.revenueTime = stats.getAverageWeekdayRevenueTime();
        this.mergedBuffers = stats.getMergedBuffers();
    }
}

