/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.stats.model;

import com.conveyal.gtfs.stats.RouteStats;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;

public class RouteStatistic
implements Serializable {
    public String route_id;
    public String routeName;
    public int headway;
    public Double avgSpeed;
    public long tripCount;
    public double stopSpacing;

    public RouteStatistic(RouteStats stats, String route_id, LocalDate date, LocalTime from, LocalTime to) {
        this.route_id = route_id;
        this.routeName = stats.getRouteName(route_id);
        this.headway = stats.getHeadwayForRouteDirection(this.route_id, 0, date, from, to);
        this.avgSpeed = stats.getSpeedForRouteDirection(this.route_id, 0, date, from, to);
        this.tripCount = stats.getTripCountForDate(this.route_id, date);
        this.stopSpacing = stats.getAverageStopSpacing(this.route_id);
    }

    public static String getHeaderAsCsv() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("route_id");
        buffer.append(",");
        buffer.append("routeName");
        buffer.append(",");
        buffer.append("headway");
        buffer.append(",");
        buffer.append("avgSpeed");
        return buffer.toString();
    }

    public String asCsv() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.route_id);
        buffer.append(",");
        buffer.append(this.routeName);
        buffer.append(",");
        buffer.append(this.headway);
        buffer.append(",");
        buffer.append(this.avgSpeed);
        return buffer.toString();
    }
}

