/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.util;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;

public class Deduplicator
implements Serializable {
    private static final long serialVersionUID = 20140524L;
    private final Map<IntArray, IntArray> canonicalIntArrays = Maps.newHashMap();
    private final Map<String, String> canonicalStrings = Maps.newHashMap();
    private final Map<BitSet, BitSet> canonicalBitSets = Maps.newHashMap();
    private final Map<StringArray, StringArray> canonicalStringArrays = Maps.newHashMap();

    public void reset() {
        this.canonicalIntArrays.clear();
        this.canonicalStrings.clear();
        this.canonicalBitSets.clear();
        this.canonicalStringArrays.clear();
    }

    public int[] deduplicateIntArray(int[] original) {
        if (original == null) {
            return null;
        }
        IntArray intArray = new IntArray(original);
        IntArray canonical = this.canonicalIntArrays.get(intArray);
        if (canonical == null) {
            canonical = intArray;
            this.canonicalIntArrays.put(canonical, canonical);
        }
        return canonical.array;
    }

    public String deduplicateString(String original) {
        if (original == null) {
            return null;
        }
        String canonical = this.canonicalStrings.get(original);
        if (canonical == null) {
            canonical = new String(original.toCharArray());
            this.canonicalStrings.put(canonical, canonical);
        }
        return canonical;
    }

    public BitSet deduplicateBitSet(BitSet original) {
        if (original == null) {
            return null;
        }
        BitSet canonical = this.canonicalBitSets.get(original);
        if (canonical == null) {
            canonical = original;
            this.canonicalBitSets.put(canonical, canonical);
        }
        return canonical;
    }

    public String[] deduplicateStringArray(String[] original) {
        if (original == null) {
            return null;
        }
        StringArray canonical = this.canonicalStringArrays.get(new StringArray(original, false));
        if (canonical == null) {
            canonical = new StringArray(original, true);
            this.canonicalStringArrays.put(canonical, canonical);
        }
        return canonical.array;
    }

    private class StringArray
    implements Serializable {
        private static final long serialVersionUID = 20140524L;
        final String[] array;

        StringArray(String[] array, boolean deduplicateStrings) {
            if (deduplicateStrings) {
                this.array = new String[array.length];
                for (int i = 0; i < array.length; ++i) {
                    this.array[i] = Deduplicator.this.deduplicateString(array[i]);
                }
            } else {
                this.array = array;
            }
        }

        public boolean equals(Object other) {
            if (other instanceof StringArray) {
                return Arrays.equals(this.array, ((StringArray)other).array);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }

    private class IntArray
    implements Serializable {
        private static final long serialVersionUID = 20140524L;
        final int[] array;

        IntArray(int[] array) {
            this.array = array;
        }

        public boolean equals(Object other) {
            if (other instanceof IntArray) {
                return Arrays.equals(this.array, ((IntArray)other).array);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }
}

